unit mgconfig;

interface
uses
    dvcrt, dvwin, dvForm, dvArq, sysutils, windows,
    mgvars, mgMsg, gramost;

procedure configPadrao;
procedure pegaParamConfig;
procedure configura;

implementation

{--------------------------------------------------------}

procedure configPadrao;
begin
    dist_eco   := DEF_DIST_ECO;
    fator_eco  := DEF_FATOR_ECO;
    dist_reverb  := DEF_DIST_REVERB;
    fator_reverb := DEF_FATOR_REVERB;
    nbufToca := DEF_BUFTOCA;
    nbufGrava := DEF_BUFGRAVA;

    proglame := 'C:\Windows\lame.exe';
    if proglame = '' then
    proglame := 'C:\Winvox\lame.exe';

    rAmostra := 44100;
    qualidade := sintAmbiente ('MINIGRAV', 'QUALIDADE');
    if qualidade = '' then
        rAmostra := 44100;

    lame_in_cmd := '-h';
    lame_out_cmd := '--decode';

    maxMemoria := 0;
end;

{--------------------------------------------------------}

procedure pegaParamConfig;
var s: string;

    function pegaInt (s: string): integer;
    var i, erro: integer;
    begin
        val (s, i, erro);
        if erro <> 0 then pegaInt := 0
                    else pegaInt := i;
    end;

begin
    s := sintAmbiente ('MINIGRAV', 'MILI_ECO');
    if s = '' then   // se no foi previamente configurado, abandona
        exit;
    dist_eco := pegaInt(s) * 10;
    s := sintAmbiente ('MINIGRAV', 'FATOR_ECO');
    fator_eco := pegaInt (s);
    s := sintAmbiente ('MINIGRAV', 'MILI_REVERB');
    dist_reverb := pegaInt (s) * 10;
    s := sintAmbiente ('MINIGRAV', 'FATOR_REVERB');
    fator_reverb := pegaInt (s);
    s := sintAmbiente ('MINIGRAV', 'MAX_MEMORIA');
    maxMemoria:= pegaInt (s);
    s := sintAmbiente ('MINIGRAV', 'NBUF_TOCA');
    nbufToca := pegaInt (s);
    s := sintAmbiente ('MINIGRAV', 'NBUF_GRAVA');
    nbufGrava := pegaInt (s);
    s := sintAmbiente ('MINIGRAV', 'QUALIDADE');
    rAmostra := pegaInt (s);
            rAmostra := 44100;
    qualidade := sintAmbiente ('MINIGRAV', 'QUALIDADE');
    if qualidade = '' then
        rAmostra := 44100;
rAmostra := strToInt(qualidade);
    if rAmostra < 44100  then
        rAmostra := 44100;
    if (rAmostra > 44100) and (rAmostra < 48000) then
        rAmostra := 48000;
    if rAmostra > 48000  then
        rAmostra := 96000;

    proglame := sintAmbiente ('MINIGRAV', 'PROG_LAME');
    if proglame = '' then
        progLame := 'c:\windows\lame.exe';
    lame_in_cmd  := sintAmbiente ('MINIGRAV', 'LAME_IN_CMD');
    lame_out_cmd := sintAmbiente ('MINIGRAV', 'LAME_OUT_CMD');
end;

{--------------------------------------------------------}

procedure salvaParamConfig;
var sz: array [0..80] of char;
begin
    strPCopy (sz, intToStr(dist_eco div 10));
    writePrivateProfileString('MINIGRAV', 'MILI_ECO', sz, 'DOSVOX.INI');
    strPCopy (sz, intToStr(fator_eco));
    writePrivateProfileString('MINIGRAV', 'FATOR_ECO', sz, 'DOSVOX.INI');
    strPCopy (sz, intToStr(dist_reverb div 10));
    writePrivateProfileString('MINIGRAV', 'MILI_REVERB', sz, 'DOSVOX.INI');
    strPCopy (sz, intToStr(fator_reverb));
    writePrivateProfileString('MINIGRAV', 'FATOR_REVERB', sz, 'DOSVOX.INI');
    strPCopy (sz, intToStr(maxMemoria));
    writePrivateProfileString('MINIGRAV', 'MAX_MEMORIA', sz, 'DOSVOX.INI');
    strPCopy (sz, intToStr(nbufToca));
    writePrivateProfileString('MINIGRAV', 'NBUF_TOCA', sz, 'DOSVOX.INI');
    strPCopy (sz, intToStr(nbufGrava));
    writePrivateProfileString('MINIGRAV', 'NBUF_GRAVA', sz, 'DOSVOX.INI');
    strPCopy (sz, proglame);
    writePrivateProfileString('MINIGRAV', 'PROG_LAME', sz, 'DOSVOX.INI');
    strPCopy (sz, intToStr(rAmostra));
    writePrivateProfileString('MINIGRAV', 'QUALIDADE', sz, 'DOSVOX.INI');
    strPCopy (sz, lame_in_cmd);
    writePrivateProfileString('MINIGRAV', 'LAME_IN_CMD', sz, 'DOSVOX.INI');
    strPCopy (sz, lame_out_cmd);
    writePrivateProfileString('MINIGRAV', 'LAME_OUT_CMD', sz, 'DOSVOX.INI');
end;

{--------------------------------------------------------}

procedure configura;
var c, c2: char;
    mili_eco, mili_reverb: integer;
begin
    clrscr;
    mensagem ('MGCONF', 2);    {'Configurando'}

    mensagem ('MGRESET', 0);   {'Deseja retornar os valores padres?'}
    sintLeTecla (c, c2);
    writeln ('MINIGRAV');
    if c = ESC then exit;

    pegaParamConfig;

    if upcase (c) = 'S' then
        begin
            dist_eco   := DEF_DIST_ECO;
            fator_eco  := DEF_FATOR_ECO;
            dist_reverb  := DEF_DIST_REVERB;
            fator_reverb := DEF_FATOR_REVERB;
            maxMemoria := 0;
            nbufToca := DEF_BUFTOCA;
            nbufGrava := DEF_BUFGRAVA;
    proglame := 'C:\Windows\lame.exe';
    if proglame = '' then
    proglame := 'C:\Winvox\lame.exe';
            rAmostra := 44100;
    qualidade := sintAmbiente ('MINIGRAV', 'QUALIDADE');
    if qualidade = '' then
        rAmostra := 44100;
rAmostra := strToInt(qualidade);
    if rAmostra < 44100  then
        rAmostra := 44100;
    if (rAmostra > 44100) and (rAmostra < 48000) then
        rAmostra := 48000;
    if rAmostra > 48000  then
        rAmostra := 96000;

            lame_in_cmd := '-h';
            lame_out_cmd := '--decode';
        end;

    garanteEspacoTela (11);
    mili_eco := dist_eco div 10;
    mili_reverb := dist_reverb div 10;

    formCria;
    formCampoInt ('MGMSECO',  pegaTextoMensagem('MGMSECO'),  mili_eco);           {'milissegundos do eco'}
    formCampoInt ('MGPERECO', pegaTextoMensagem('MGPERECO'), fator_eco);          {'percentual do eco'}
    formCampoInt ('MGMSREV',  pegaTextoMensagem('MGMSREV'),  mili_reverb);        {'milissegundos do reverber'}
    formCampoInt ('MGPERREV', pegaTextoMensagem('MGPERREV'), fator_reverb);       {'percentual do reverber'}
    formCampoInt ('MGMAXMEM', pegaTextoMensagem('MGMAXMEM'), maxMemoria);         {'memria em Mb (0=toda)'}
    formCampoInt ('MGNBUFT',  pegaTextoMensagem('MGNBUFT'),  nbufToca);           {'buffers para tocar'}
    formCampoInt ('MGNBUFG',  pegaTextoMensagem('MGNBUFG'),  nbufGrava);          {'buffers para gravar'}
    formCampo    ('MGCNVMP3', pegaTextoMensagem('MGCNVMP3'), proglame, 80);       {'converso mp3'}
    formCampoInt ('MGQUALID', pegaTextoMensagem('MGQUALID'), rAmostra);       {'Qualidade do som, 44100, 4800 ou 9600; padro 44100']
    formCampo    ('MGMP3OUT', pegaTextoMensagem('MGMP3OUT'), lame_out_cmd, 80);   {'parametros para gerar mp3'}
    formCampo    ('MGMP3IN',  pegaTextoMensagem('MGMP3IN'),  lame_in_cmd,  80);   {'parametros para ler mp3'}
    formCampo    ('MGMP3OUT', pegaTextoMensagem('MGMP3OUT'), lame_out_cmd, 80);   {'parametros para gerar mp3'}
    formEdita(true);

    dist_eco := mili_eco * 10;
    dist_reverb := mili_reverb * 10;

    if dist_eco = 0 then dist_eco := DEF_DIST_ECO;
    if fator_eco = 0 then fator_eco := DEF_FATOR_ECO;
    if dist_reverb = 0 then dist_reverb := DEF_DIST_REVERB;
    if fator_reverb = 0 then fator_reverb := DEF_FATOR_REVERB;

    if (nbufToca  < 2) or (nbufToca  > 8) then nbufToca  := DEF_BUFTOCA;
    if (nbufGrava < 2) or (nbufGrava > 8) then nbufGrava := DEF_BUFGRAVA;

    som.maxMemoria := maxMemoria * 1024 * 1024;

    salvaParamConfig;

    mensagem ('MGOKCONF', 2);    {'OK, configurado'}
    sintBip; sintBip; sintBip;
end;

end.
