{--------------------------------------------------------}
{    Conversor de formatos de som
{    Por Jos Antonio Borges
{    Em 29/05/98
{--------------------------------------------------------}

program convsons;
uses windows, dvcrt, dvwin, gramost, classes, sysutils;

var
    nomeDir: string;
    narq: integer;
    velocidade, bitsPorAmostra, canais: integer;
    nomesArqs: TStringList;

label fim;

{--------------------------------------------------------}

function achaNumArqs (nomeDir: string): integer;
var
    buscado: TSearchRec;
    numArqs: integer;
    dosError: integer;
begin
    nomesArqs := TStringList.create;

    numArqs := 0;
    dosError := FindFirst ('*.WAV', FAARCHIVE, buscado);
    while dosError = 0 do
        begin
            nomesArqs.Add(buscado.FindData.cFileName);
            dosError := FindNext(buscado);
            numArqs := numArqs + 1;
        end;

    achaNumArqs := numArqs;
end;

{--------------------------------------------------------}

procedure inicializa;
begin
    ScreenSize.y := 10;
    sintInic (0, '');
    sintFalaPont := false;
    sintWriteln ('Conversor de formatos de SOM');
    writeln;
    while sintFalando do;

    sintWriteln ('Informe nome do diretrio a converter');
    sintReadln (nomeDir);
    if nomeDir = '' then
        begin
            sintFim;
            doneWinCrt;
        end;

    {$I-} chDir (nomeDir);  {$I+}
    if ioresult <> 0 then
        begin
            sintWriteln ('Diretrio inexistente');
            delay (10);
            sintFim;
            doneWinCrt;
        end;

    sintWriteln ('Velocidade final (sugiro 11025, 22050 ou 44100): ');
    sintReadint (velocidade);
    sintWriteln ('Bits por amostra (8 ou 16): ');
    sintReadint (bitsPorAmostra);
    sintWriteln ('Canais (1 ou 2):');
    sintReadint (canais);

    narq := achaNumArqs (nomeDir);

    sintWriteln ('Convertendo ' + intToStr (narq) + ' arquivos');
end;

{--------------------------------------------------------}

procedure converteArquivo (n: integer);
var nomeArq: string;
    som, som2: TAmostras;
begin
    nomeArq := nomesArqs [n];
    writeln (nomeArq);
    
    som := TAmostras.Create;
    som.leArquivo(nomeArq);

    som2:= TAmostras.Create;
    som2.reAmostra (som, velocidade);
    som2.bitsPorAmostra := bitsPorAmostra;
    som2.canais := canais;
    som.Free;
    som := som2;
    som2 := NIL;

    if not som.gravaArquivo(nomeArq) then
        begin
            sintWriteln ('Erro de gravao: ' + nomeArq);
            sintWriteln ('Aperte enter');
            readln;
        end;
end;

{--------------------------------------------------------}

procedure finaliza;
begin
    nomesArqs.Free;
    sintWriteln ('OK');
    sintFim;
    doneWinCrt;
end;

{--------------------------------------------------------}

var i: integer;
begin
    inicializa;
    for i := 0 to narq-1 do
        converteArquivo (i);
    writeln;
    finaliza;
end.
