{ --------------------------------------------------------}
{
{    Mini gravador de som
{
{    Por Jos Antonio Borges
{        Mara Lcia Caldeira
{        Marcolino Matheus de Souza Nascimento
{
{    Verso 1.0 Em 29/05/98
{    Verso 2.0 em maio/2006
{    Verso 3.0 em fevereiro/2016
{
{--------------------------------------------------------}

program minigrav;

uses
  dvcrt, dvwin, dvform, dvarq, dvwav,
  windows, messages, sysutils, mmsystem,
  grAmost,  mgVars, mgMsg, mgEfeito, mgefeitoSox, mgmp3,
  mgdivide, mgconfig, mgArquivo, mgRemove,
  mgToca, mgMistura, mgGrava;

{---------------------------------------------------------------------}

procedure inicializa;
var dir: string;
begin
    clrscr;
    setWindowText (crtWindow, 'GRAVADOR DE SOM');
    delay (200);

    getDir (0, dirTrab);
    if dirTrab [length (dirTrab)] <> '\' then dirTrab := dirTrab + '\';

    dir := sintAmbiente ('MINIGRAV', 'DIRMINIGRAV');
    if dir = '' then
        dir := 'c:\winvox\som\minigrav';

    dirSox := sintAmbiente ('MINIGRAV', 'DIRSOX');
    if dirSox = '' then
        dirSox := 'C:\Winvox\sox\sox.exe';

    sintInic (0, dir);

    mensagem ('MGINIC', 0);  {'Gravador de som'}
    write (' - v.');
    sintWrite (versao);
    writeln;
    writeln;
    while sintFalando do waitMessage;

    nomeArq := '';
    som:= TAmostras.Create;
    cursor := 0;
    marca := 0;

    configPadrao;
    pegaParamConfig;
    som.maxMemoria := maxMemoria * 1024 * 1024;
end;

{--------------------------------------------------------}

function finaliza: boolean;
var opcao: char;
    c, c2: char;
begin
    finaliza := false;
    mensagem ('MGCONFIM', 0); {'Confirma o fim do programa ? '}
    opcao:= sintReadKey;
    writeln;

    if (upcase(opcao) = 'S') or
    (upcase(opcao) = ESC) then
else
        exit;

    mensagem ('MGQUERSV', 0);   {'Quer salvar arquivo atual? '}
    sintLeTecla (c, c2);
    writeln;
    if c = ESC then exit;

    if upcase(c) <> 'N' then
        begin
            salvaArquivoRapido;
            veSeSalvaMP3 (nomeArq );
        end;

    som.free;
    DeleteFile(pchar(arqtemp1));
    finaliza := true;
end;

{--------------------------------------------------------}

procedure undo;
var c, c2: char;
begin
    mensagem ('MGCNFUND', 0);   {'Vou recuperar a ltima verso salva, confirma? '}
    sintLeTecla (c, c2);
    writeln;
    if upcase (c) <> 'S' then exit;

    som.leArquivo(nomeArq);
    mensagem ('MGUNDO', 1);  {'Voltei ao ltimo arquivo gravado'}
end;

{--------------------------------------------------------}

procedure undo1;
var c, c2: char;
begin
    som.leArquivo(nomeArq);
end;

{--------------------------------------------------------}

procedure salvaArquivo1 (nomeArq: string);
var t, c, c2: char;
    nomeNovo: string;
    som2: TAmostras;
    pnome: array [0..255] of char;
var aRemover, i, m, cursor1: integer;

label desistiu, salvamentoMP3;
begin
i:= som.numAmostras;
cursor1 := cursor;

    aRemover := abs (som.numAmostras - cursor);
    if cursor < som.numAmostras then
        i := cursor
    else
        cursor := som.numAmostras;
    som.removeTrecho(cursor, aRemover);

cursor := 0;

    aRemover := abs (marca - cursor);
    if cursor < marca then
        marca := cursor
    else
        cursor := marca;
    som.removeTrecho(cursor, aRemover);

cursor := cursor1;

    som2 := NIL;
    nomeNovo := nomeArq;

    mensagem ('MGNOMNAR', 1);            {'Informe o novo nome do arquivo: '}
    garanteEspacoTela(2);
    c := sintEdita (nomeNovo, wherex, wherey, 255, true);
    writeln;
    if (c = ESC) or (nomeNovo = '') then goto desistiu;

    if (maiuscAnsi (copy (nomeNovo, length (nomeNovo)-3, 4)) = '.MP3') or
                                   (pos ('.', nomeNovo) = 0) then
         nomeNovo:= nomeNovo + '.wav';

    mensagem ('MGRADTLF', 0);  {'Qualidade CD, rdio ou telefone ? '}
    sintLeTecla (t, c2);
    writeln;
    if t = ESC then exit;

    mensagem ('MGSTMONO', 0);  {'Estreo ou Mono? '}
    sintLeTecla (c, c2);
    writeln;
    if c = ESC then goto desistiu;

    som2:= TAmostras.Create;
    case upcase(t) of
        'C':  begin
                  som2.reAmostra (som, 44100);
                  som2.bitsPorAmostra := 16;
              end;
        'T':  begin
                  som2.reAmostra (som, 11025);
                  som2.bitsPorAmostra := 8;
              end;
        else
              begin
                  som2.reAmostra (som, 22050);
                  som2.bitsPorAmostra := 16;
              end;
    end;

    if upcase (c) in ['E', 'S'] then
        som2.canais := 2
    else
        som2.canais := 1;

    som.Free;
    som := som2;
    som2 := NIL;

    if not som.gravaArquivo(nomeNovo) then
        begin
            mensagem ('MGERRGRV', 1);      {'Erro de gravao'}
            exit;
        end
    else
        nomeArq := nomeNovo;

    mensagem ('MGARQSLV', 2);       {'OK, arquivo salvo'}
undo1;
    strPCopy (pnome, 'MINIGRAV ' + nomeArq);
    setWindowText (crtWindow, pnome);

salvamentoMP3:
    veSeSalvaMP3 (nomeNovo);
    exit;

desistiu:
    if som2 <> NIL then som2.free;
    mensagem ('MGDESIST', 1);        {'Desistiu'}
end;

{--------------------------------------------------------}

procedure infoSom;
var s: string;
begin
    mensagem ('MGARQTRB', 0);           {'Arquivo de trabalho: '}
    s := nomeArq;
    if maiuscAnsi (copy (s, length(s)-7, 8)) = '.MP3.WAV' then
        delete (s, length(s)-3, 4);
    sintWriteln (s);

    mensagem ('MGIVEL', 0);             {'Velocidade: '}
    sintWriteint (som.velocidade);
    writeln;

    mensagem ('MGIQUALI', 0);           {'Qualidade: '}

    if som.bitsPorAmostra = 8 then
        mensagem ('MGI8BIT',  1)        {'8 Bits '}
    else
        mensagem ('MGI16BIT', 1);       {'16 Bits '}

    if som.canais = 1 then
        mensagem ('MGIMONO', 1)         {'Mono'}
    else
        mensagem ('MGISTERE', 1);       {'Stereo'}

    while sintFalando do waitMessage;
    writeln;
end;

{--------------------------------------------------------}

procedure ajudaPrincipal;
begin

    textBackground (RED);
    mensagem ('MGASOPC',1); {'As opes so:'}
    textBackground (BLACK);
    writeln;

    mensagem ('MGTOCA', 1);   {'T - Toca'}
    mensagem ('MGGRAVA', 1);  {'G - Grava mais'}
    mensagem ('MGNOVO', 1);   {'N - Novo som'}
    mensagem ('MGREMOVE', 1); {'R - Remove'}
    mensagem ('MGMIXA', 1);   {'M - Mistura'}
    mensagem ('MGEFEIT', 1);  {'E - Efeito'}
    mensagem ('MGDESFAZ', 1); {'D - Desfaz'}
    mensagem ('MGSALVA', 1);  {'S - Salva'}
    mensagem ('MGEXTRAI', 1); {'X - Extrai'}
    mensagem ('MGCONFIG', 1); {'C - Configura'}
    mensagem ('MGPARTE', 1); {'P - Parte'}
    mensagem ('MGINFO', 1);   {'I - Informaes'}
end;

{--------------------------------------------------------}
{            seleciona a opo com as setas
{--------------------------------------------------------}

procedure MenuAdiciona (msg: string);
begin
    popupMenuAdiciona (msg, pegaTextoMensagem (msg));
end;

{--------------------------------------------------------}

function selSetasPrincipal: char;
var n: integer;

const tabLetrasOpcoes: string = 'tgnrmedsxcpi';
var nopc: integer;

begin
    sintSom ('MGMENU');
    mensagem ('MGASOPC',1); {'As opes so:'}

    nopc := length (tabLetrasOpcoes);
    garanteEspacoTela(nopc);
    popupMenuCria (wherex, wherey, 18, nopc, MAGENTA);
    menuAdiciona ('MGTOCA');    {'T - Toca'}
    menuAdiciona ('MGGRAVA');   {'G - Grava mais'}
    menuAdiciona ('MGNOVO');    {'N - Novo som'}
    menuAdiciona ('MGREMOVE');  {'R - Remove'}
    menuAdiciona ('MGMIXA');    {'M - Mistura'}
    menuAdiciona ('MGEFEIT');   {'E - Efeito'}
    menuAdiciona ('MGDESFAZ');  {'D - Desfaz'}
    menuAdiciona ('MGSALVA');   {'S - Salva'}
    menuAdiciona ('MGEXTRAI');  {'X - Extrai'}
    menuAdiciona ('MGCONFIG');  {'C - Configura'}
    menuAdiciona ('MGPARTE');  {'P - Parte o arquivo'}
    menuAdiciona ('MGINFO');    {'I - Informaes'}

    n := popupMenuSeleciona;

    if (n > 0) and (n <= nopc) then
        selSetasPrincipal := tabLetrasOpcoes[n]
    else
//        selSetasPrincipal := ESC;
        selSetasPrincipal := ENTER;
end;

{--------------------------------------------------------}
{               ciclo de processamento geral
{--------------------------------------------------------}

procedure menuPrincipal;
var
    processando: boolean;
    c, c2: char;
label executa;
begin
    processando := true;
    while processando do
        begin
            while keypressed do readkey;

            textBackground (BLUE);
            mensagem ('MGOPMG', 0);   {'Gravador, qual sua opcao? '}
            textBackground (BLACK);

            sintLeTecla (c, c2);
            writeln;

           if (c = #0) and (c2 = F4) then
begin
        mensagem ('MGVELOC', 1);  {'Qual a velocidade, de 1 a 5'}
    sintLeTecla (c, c2);
    writeln;
    if c in ['1'..'5'] then
        begin
            sintFim;
            sintInic (ord(c) - ord('0'), sintambiente ('MINIGRAV', 'DIRMINIGRAV'));
end;
end
           else
           if (c = #0) and (c2 = CTLF4) then
begin
c := '5';
        begin
            sintFim;
            sintInic (ord(c) - ord('0'), sintambiente ('MINIGRAV', 'DIRMINIGRAV'));
end;
end
           else
           if (c = #0) and (c2 = CTLF3) then
begin
c := '4';
        begin
            sintFim;
            sintInic (ord(c) - ord('0'), sintambiente ('MINIGRAV', 'DIRMINIGRAV'));
end;
end
else
           if (c = #0) and (c2 = CTLF2) then
begin
c := '3';
        begin
            sintFim;
            sintInic (ord(c) - ord('0'), sintambiente ('MINIGRAV', 'DIRMINIGRAV'));
end;
end
           else
           if (c = #0) and (c2 = CTLF1) then
begin
c := '2';
        begin
            sintFim;
            sintInic (ord(c) - ord('0'), sintambiente ('MINIGRAV', 'DIRMINIGRAV'));
end;
end
else

            if c = #$0 then
                begin
                    if c2 = DEL then
                        clrscr
                    else
                    if c2 = F1 then
                        ajudaPrincipal
                    else
                    if c2 = F2 then
                        salvaArquivoRapido
                    else
                    if c2 = F3 then
                    begin
                        mensagem ('MGQUERSV', 0);   {'Quer salvar arquivo atual? '}
                        sintLeTecla (c, c2);
                        writeln;
                        if (upcase(c) <> 'N') and (upcase(c2) = ENTER) then
                            salvaArquivoRapido;
                        nomeArq := '';
                        carregaSom;
                        mensagem ('MGOK', 1); {'Ok'}
                    end
                    else
                    if (c2 = CIMA) or (c2 = BAIX) then
                        begin
                            c := selSetasPrincipal;
                            goto executa;
                        end
                end
            else
               begin
        executa:
                    case upcase(c) of

                        'T': tocaSom;
                        'G': gravaMais;
                        'N': novaGravacao;
                   'A', 'R': trataRemocao;
                        'M': misturaOutroSom;
                        'E': menuEfeito;
                        'D', 'U': undo;
                        'S': salvaArquivo (nomeArq);
                        'X': extraiArquivo;
                        ^X: begin
    delay (3);
        SintFim;
        doneWinCrt;
                        end;
                        'C': configura;
                        'P': salvaArquivo1 (nomeArq);
                        'I': infoSom;
                        ESC: if finaliza then
                                 processando := false;
                    else
                    if c <> ENTER then
                        mensagem ('MGOPINV', 2); {'Opo invlida, F1 ajuda'}
                    end;
                end;
        end;
end;

{--------------------------------------------------------}

procedure termina;
begin
    mensagem ('MGFIM', 1);      {'Fim do programa'}
    sintFim;
    doneWinCrt;
end;

{--------------------------------------------------------}

begin
    inicializa;

    obtemNomeArquivo (true);
    if nomeArq <> '' then
        begin
            if not FileExists(nomeArq) then
                 gravaSomInicial;

            carregaSom;
            arqtemp1 := GetTempDir+ExtractFileName(nomeArq); // salva memria em temp
        end;

    writeln;
    menuPrincipal;

    termina;
end.
