{ Formatvox - Funes de uso geral
{ Por Lucas Alexandre
{ Em Maio/2015 }

unit fvutils;

interface

uses dvCrt, dvForm, dvWin, minireg, pipe, ShellAPI, sysUtils, windows, fvmsg;
var cmd: string;
ffmpeg: string;
ffplay: string;
procedure terminar;
procedure cabecalho;
function execFFMpeg(params: string; nomeArq: string=''): boolean;
function ExecArquivo(nomeArq: string): boolean;
function verificaFfmpeg: boolean;
function PegaNomeArq(nomeArq: string): string;
function PegaCaminhoArq(nomeArq: string): string;
function RemoveExtensao(nomeArq: string): string;
function TamanhoArquivo(s: string): longint;
procedure TituloPadrao;
function ChecaNomeArq(nomeArq: string): boolean;
procedure CopiaDiretorio(origem: string; destino: string);
procedure mataprocesso(proc: string);
function SelecionaPreferido: string;

implementation

uses fvcfg,fvvars;

{ Faz o trmino do formatvox }

procedure terminar;
begin
mensagem('FVFIM');
sintSom('e_end');
while sintfalando do delay(10);
sintFim;
doneWinCRT;
halt;
end;

{ Coloca o cabealho do Formatvox no topo da tela }

procedure cabecalho;
begin
clrscr;
textBackground(Blue);
writeln('Formatvox - Conversor multimdia');
textBackground(Black);
writeln;
end;

{ Verifica se o FFMpeg est instalado }

function verificaFfmpeg: boolean;
begin
verificaFfmpeg := false;
ffmpeg := sintAmbiente('FORMATVOX', 'FFMPEG');
ffplay:=sintAmbiente('FORMATVOX','FFPLAY');
if ffmpeg = '' then
ffmpeg := 'C:\winvox\ffmpeg.exe';
if ffplay='' then
ffplay:= 'C:\winvox\ffplay.exe';
if not fileExists(ffmpeg) then exit;
if not fileExists(ffplay) then exit;
verificaFfmpeg := true;
end;

{ Executa um arquivo com a ferramenta FFPlay }

function ExecArquivo(nomeArq: string): boolean;
begin
shellExecute(hwnd(0),pchar('open'),pchar(ffplay),pchar('"'+nomeArq+'"'),pchar(''),0);
while processExists('ffplay.exe') do delay(10);
end;

{ Executa uma operao com o FFMpeg }

function execFFMpeg(params: string; nomeArq: string=''): boolean;
var c: char;
begin
shellExecute(hwnd(0),pchar('open'),pchar(ffmpeg),pchar( ' -y '+params),pchar(''),0);
while processExists('ffmpeg.exe') do
begin
delay(10);
c:=#0;
if bipando then sintClek;
if keypressed then c:=readkey;
if (c=#13) and (nomeArq<>'') then
begin
cabecalho;
sintWriteln('Convertendo arquivo '+nomeArq+' ('+copy(floattostr(TamanhoArquivo(nomeArq)/1024/1024),1,6)+' MB)');
end
else
if c=#32 then
begin
sintBip;
if bipando then
bipando:=false
else
bipando:=true;
end
else
if upcase(c)=ESC then
begin
cabecalho;
sintWriteln('Confirma o cancelamento da operao atual?');
c:=readkey;
sintCarac(c);
if upcase(c)='S' then
begin
mataprocesso('ffmpeg.exe');
sintWriteln('Operao cancelada.');
execFFMpeg:=false;
exit;
end;
end
else
if upcase(c) in ['A'..'Z','0'..'9'] then sintetiza('Por favor, aguarde enquanto a operao  executada ou tecle ESC para cancelar.')
end;
execFFMpeg:=true;
end;

{ Remove a extenso do nome de um arquivo }

function RemoveExtensao(nomeArq: string): string;
var c: char; TamNome: integer;
begin
TamNome:=length(nomeArq);
while c<>'.' do
begin
c:=nomeArq[tamNome];
TamNome:=TamNome-1;
end;
nomeArq:=copy(nomeArq,1,tamNome);
RemoveExtensao:=nomeArq;
end;

{ Pega o nome do arquivo de um caminho }

function PegaNomeArq(nomeArq: string): string;
var c: char; TamNome: integer;
begin
TamNome:=length(nomeArq);
while c<>'\' do
begin
TamNome:=TamNome-1;
c:=nomeArq[TamNome];
end;
TamNome:=TamNome+1;
nomeArq:=copy(nomeArq,TamNome,length(nomeArq));
PegaNomeArq:=nomeArq;
end;

{ Pega o caminho de um arquivo }

function PegaCaminhoArq(nomeArq: string): string;
var c: char; tamnome: integer;
begin
PegaCaminhoArq:='';
TamNome:=length(nomeArq);
while c<>'\' do
begin
dec(TamNome);
c:=nomeArq[TamNome];
end;
dec(TamNome);
pegaCaminhoArq:=copy(nomeArq,1,tamNome);
end;

{ Retorna o tamanho de um arquivo }

function TamanhoArquivo(s: string): longint;
var arq: file of Byte;
begin
assign(arq,s);
{$I-}
reset(arq);
TamanhoArquivo:=filesize(arq);
close(arq);
end;

{ Define ttulo da janela como padro }

procedure TituloPadrao;
begin
clrscr;
SetWindowText(crtWindow,'Formatvox - Conversor multimdia');
end;

{ Checa existncia de um arquivo }

function ChecaNomeArq(nomeArq: string): boolean;
begin
ChecaNomeArq:=false;
if nomeArq='' then
begin
mensagem('FVDESIST'); {'Desistiu'}
exit;
end;
if not fileExists(nomeArq) then
begin
mensagem('FVINARQ');  {'Arquivo no existe.'}
exit;
end
else
ChecaNomeArq:=true;
end;

{ Copia um diretrio para outro }

procedure CopiaDiretorio(origem: string; destino: string);
var
ShFileOpStruct: TShFileOpStruct;
begin
  FillChar(ShFileOpStruct,Sizeof(TShFileOpStruct),0);
  with ShFileOpStruct do
    begin
    wFunc := FO_COPY;
    pFrom := PChar(origem +#0);
    pTo := PChar(destino + #0);
    fFlags := FOF_ALLOWUNDO or FOF_SIMPLEPROGRESS or FOF_NOCONFIRMATION;
  end;
    ShFileOperation(ShFileOpStruct);
end;

{ Mata um processo }

procedure mataprocesso(proc: string);
begin
shellExecute(hwnd(0),pchar('open'),pchar('taskkill'),pchar('/f /im '+proc),pchar(''),0);
end;

{ Seleciona diretrio preferido }
{ Extrado de doscopia.pas }

function SelecionaPreferido: string;
var diratual: string;
n, p, nprefs: integer;
    c: char;
    diret, s: string;
    dir: array [1..50] of string;
    np: integer;

const
    SearchTree = 'Software\Microsoft\Windows\CurrentVersion\Explorer\Shell Folders\';
begin
            writeln;
            nprefs := 0;
            for n := 1 to 50 do
                begin
                    s := sintAmbiente ('PREFERIDOS', 'DIRPREF' + intToStr (n));
                    if s <> '' then nprefs := nprefs + 1;
                end;

             popupMenuCria (49, wherey, 50, nprefs, RED);
             np := 0;
             for n := 1 to 50 do
                 begin
                     s := sintAmbiente ('PREFERIDOS', 'DIRPREF' + intToStr (n));
                     if s <> '' then
                         begin
                             np := np + 1;
                             p := pos (',', s);
                             dir [np] := copy (s, 1, p-1);
                             popupMenuAdiciona ('', copy (s, p+1, 99));
end;
end;

             popupMenuOrdena;
             n := popupMenuSeleciona;
             if n > 0 then
                 diret := dir [n]
             else
                 diret := '';

    getdir (0, diratual);

    if (diret <> '') and (diret[1] = '*') then
        begin
            delete (diret, 1, 1);
            if not regGetString (HKEY_CURRENT_USER, SearchTree+diret, diret) then
                diret := '@@@'
        end;

    {$I-} chdir (diret);  {$I+}
    if ioresult <> 0 then
        begin
            {$I-} chdir (diratual);  {$I+}
            if ioresult <> 0 then;
            exit;
        end;

    getdir (0, diret);
    {$I-}  chdir (diratual);  {$i+}
    if ioresult <> 0 then;

    if diret [length(diret)] <> '\' then
        diret := diret + '\';
selecionaPreferido:=diret;
end;

end.
