{ Formatvox - Mdulo de gravao de discos
{ Por Lucas Alexandre
{ Em Agosto/2015 }

unit fvdiscos;

interface

uses dvCrt, dvForm, dvWin, fileCtrl, fvArq, fvCfg, fvdvd, fvmsg, fvutils, pipe, ShellAPI, sysUtils, windows;
const
BUFSIZE=8192;
type
TCD8K = array[0..BUFSIZE-1] of byte;
var
btsIO: DWord;
hDevice: THandle;
PathCDBXP: string;

function GravacaodeDiscos: boolean;
function VerificaCDBXP: boolean; forward;
procedure ExecutaCDBXP(params: string); forward;
procedure EjetaCD; forward;

implementation

uses classes, dvArq, mftdirs;

{ Apaga um disco regravvel }

procedure ApagaDisco;
procedure ApagaDisco2;
begin
SetWindowText(crtWindow,'Formatvox - Apagando disco');
ExecutaCDBXP('--erase');
EjetaCD;
cabecalho;
sintWriteln('Fim do apagamento');
end;

var c: char;
begin
cabecalho;
sintBip; sintBip; sintBip;
mensagem('DVPERIGO'); {'Ateno: Esta operao  irreversvel e pode causar imensos danos.'}
mensagem('FVAD2');
sintWriteln(DiskLabel(ProcuraDrive));
mensagem('FVAD3');
mensagem('FVAD4');
c:=upcase(readkey);
if c='S' then ApagaDisco2
else exit;
end;

{ Abre um handle para o disco }

function AbreCDHandle: boolean;
begin
AbreCDHandle:=true;
  hDevice := CreateFile(pchar('\\?\'+ProcuraDrive+':'),GENERIC_READ,
      FILE_SHARE_READ or FILE_SHARE_WRITE, nil, OPEN_EXISTING, 0, 0);
    if hDevice=INVALID_HANDLE_VALUE then
    AbreCDHandle:=false;
end;

{ L 8K do disco }

function RDCD8K: TCD8K;
var
CDSector: TCD8K;
begin
    ReadFile(hDevice,CDSector[0],BUFSIZE,btsIO,nil);
    RDCD8K:=CDSector;
end;

{ Grava uma imagem em um disco }

procedure GravaImagemDisco;
var
c: char;
extensao: string[3];
cmd, nomeArq: string;
begin
cabecalho;
mensagem('FVID1'); writeln;
mensagem('FVID2');
sintReadln(nomeArq);
if not ChecaNomeArq(nomeArq) then exit;
extensao:=ansiUpperCase(copy(nomeArq,length(nomeArq)-2,length(nomeArq)) );
if (extensao<>'ISO') and (extensao<>'BIN') then
begin
mensagem('FVID3'); mensagem('FVID4');
exit;
end;
writeln;
mensagem('FVID5'); writeln;
mensagem('FVID6'); sintWriteln(nomeArq); writeln;
mensagem('FVID7');
c:=upcase(readkey);
sintCarac(c);
if c=ENTER then
begin
sintSom('e_end');
mensagem('FVID8');
cmd:='-burn-iso -file:"'+nomeArq+'" -speed 4 -close -eject';
setWindowText(crtWindow,'Formatvox - Gravando imagem em disco');
ExecutaCDBXP(cmd);
delay(1000);
EjetaCD;
mensagem('FVID9');
exit;
end;
mensagem('FVDESIST'); {'Desistiu'}
exit;
end;

{ Cria disco de dados }

procedure CriaDiscodeDados;
var
dkname,dir: string;
NoMenu: boolean;
struct: TStringList;
tipo: char;
function MenuCDD: integer;
begin
PopUpMenuCria(wherex,wherey,58,10,MAGENTA);
PopUpMenuAdiciona('','  A - Adicionar arquivo');
PopUpMenuAdiciona('','  D - Adicionar diretrio');
PopUpMenuAdiciona('','  F - Folhear estrutura do disco');
PopUpMenuAdiciona('','  N - Alterar nome do disco');
MenuCDD:=PopUpmenuSeleciona;
end;

procedure CDDOpcoes;
{ Procedures abaixo pertencem a CDDOpcoes }
procedure CDDAdicionaArq;
var
nomeArq: string;
begin
cabecalho;
sintWriteln('Adicionar arquivo'); writeln;
sintWriteln('Informe o nome do arquivo a adicionar:');
GaranteEspacoTela(10);
sintReadln(nomeArq);
if nomeArq='' then nomeArq:=SelecionaArquivo;
if not ChecaNomeArq(nomeArq) then exit;
Struct.Add(nomeArq);
mensagem('FVOK'); {'Ok!'}
end;

procedure CDDAdicionaDir;
var
nomeDir: string;
begin
cabecalho;
sintWriteln('Informe o nome do diretrio a adicionar:');
sintReadln(nomeDir);
if nomeDir='' then nomeDir:=SelecionaPreferido;
if not DirectoryExists(nomeDir) then
begin
mensagem ('FVINDIR'); {'Diretrio inexistente'}
exit;
end;
struct.Add(nomeDir);
mensagem('FVOK'); {'Ok!'}
end;

procedure CDDReconstroi;
var
i: integer;
begin
for i:=0 to struct.count-2 do
begin
if struct[i]='' then struct.Delete(i);
end;
end;

procedure CDDAcoesLista(dado: integer);
const
opcoes='A';
var
item: integer;
opcao: char;
begin
cabecalho;
sintWriteln('O que fazer com este dado?');
PopUpMenuCria(wherex,wherey,58,10,MAGENTA);
PopUpMenuAdiciona('','Apagar');
item:=PopUpMenuSeleciona;
if item=1 then
begin
struct[dado]:='';
CDDReconstroi;
exit;
end;
sintBip;
exit;
end;

procedure CDDFolheia;
var
i,item: integer;
begin
cabecalho;
if struct.Count=0 then
begin
sintWriteln('A lista de dados est vazia.');
exit;
end;
sintWriteln('Folheando estrutura do disco.');
sintWriteln('Use as setas e tecle Enter para escolher uma opo; ESC para voltar.');
cabecalho;
CDDReconstroi;
PopUpMenuCria(wherex,wherey,58,10,MAGENTA);
for i:=0 to struct.Count-1 do PopUpMenuAdiciona('',struct[i]);
item:=PopUpmenuSeleciona;
if item=0 then exit;
CDDAcoesLista(item-1);
end;

procedure CDDGera;
var
separador: TStringList;
i: integer;
ShFileOpStruct: TShFileOpStruct;
begin
cabecalho;
writeln;
repeat
sintWriteln('Pressione: D para gravar um disco de dados, ou A para gravar um disco de udio.');
tipo:=upcase(sintReadkey);
until (tipo='D') or (tipo='A');
sintWriteln('Preparando disco para gravao. Isto pode levar alguns minutos.');
for i:=0 to struct.count-1 do
begin
if fileExists(struct[i]) then
copyfile(pchar(struct[i]),pchar(dir+'\'+PegaNomeArq(struct[i])),true)
else
if DirectoryExists(struct[i]) then
CopiaDiretorio(struct[i],dir);
end;
if tipo='A' then
begin
sintWriteln('Distribuindo faixas...');
separador:=TStringList.Create;
GetDriveStructure(dir,separador);
for i:=0 to separador.Count-1 do
copyfile(pchar(separador[i]),pchar(dir+'\'+PegaNomeArq(separador[i])),true);
end;
end;

procedure CDDGrava;
var
cmd: string;
c: char;
begin
cabecalho;
sintWriteln('Disco gerado com sucesso.');
writeln;
sintWriteln(inttostr(struct.Count)+' arquivos e diretrios adicionados ao disco.');
writeln;
mensagem('FVID5'); {'Informaes sobre a gravao'}
writeln;
mensagem('FVCPD5'); {'Nome do disco'}
sintWriteln(dkname);
sintWriteln('Total de arquivos e diretrios a gravar: '+inttostr(struct.Count));
sintWriteln('Pressione Enter para continuar ou ESC para cancelar.');
c:=readkey;
sintcarac(c);
c:=upcase(c);
if c=ESC then
begin
sintWriteln('Operao cancelada.');
exit;
end;
sintWriteln('Por favor, insira um disco em branco e legvel na unidade '+ProcuraDrive);
sintWriteln('Pressione Enter aps inserir o disco.');
c:=readkey;
if tipo='D' then
cmd:='-burn-data -file[\]:"'+dir+'" -name:'+dkname+' -speed 4 -close -eject'
else
if tipo='A' then
cmd:='--burn-audio -file[\]:"'+dir+'" -name:'+dkname+' -speed 4 -close -eject';
setWindowText(crtWindow,pchar('Formatvox - Gravando disco '+dkname));
ExecutaCDBXP(cmd);
cabecalho;
sintWriteln('Processo de gravao foi concludo.');
if c='D' then
sintWriteln(inttostr(struct.count)+' arquivos e diretrios foram gravados no disco '+dkname)
else
if c='A' then
sintWriteln(inttostr(struct.Count)+' arquivos gravados no disco de udio.');
struct.Free;
chdir(FVDIR);
end;

procedure CDDNome;
begin
cabecalho;
sintWriteln('Edite o nome do disco:');
sintEdita(dkname,wherex,wherey,11,true);
mensagem('FVOK'); {'Ok!'}
end;

const
opcoes='ADF';
var
item: integer;
c, opcao, op, op2: char;
begin
cabecalho;
sintWriteln('Criando disco de dados'); writeln;
textBackGround(BLUE);
mensagem('FVQUOP'); {'Qual sua opo?'}
textBackground(BLACK);
sintLeTecla(op,op2);
writeln;
if (op2=CIMA) or (OP2=BAIX) then
begin
item:=MenuCDD;
if item=0 then exit;
opcao:=opcoes[item];
end
else
opcao:=upcase(op);

case op of
ESC: begin
sintWriteln('Deseja criar o disco agora? (sim, no ou ESC.)');
c:=readkey;
if c=#27 then exit;
sintCarac(c);
c:=upcase(c);
if c='S' then
begin
if struct.Count=0 then
begin
sintWriteln('Impossvel! Nenhum arquivo ou diretrio foi adicionado a gravao.');
exit;
end;
CDDGera;
CDDGrava;
appExecute('cmd /c rmdir /s /q "'+dir+'"');
exit;
end
else
begin
NoMenu:=false;
chdir(FVDIR);
appExecute('cmd /c rmdir /s /q "'+dir+'"');
exit;
end;
end;
end;

case opcao of
'A': CDDAdicionaArq;
'D': CDDAdicionaDir;
'F': CDDFolheia;
'N': CDDNome;
else
begin
mensagem('FVOPINV'); {'Opo invlida.'}
mensagem('FVAJCONOP'); {'Use as setas para conhecer as opes.'}
end;
end;
end;

begin
cabecalho;
mensagem('FVDD1'); {'Criar disco de dados'}
writeln;
randomize;
dir:=GetEnvironmentVariable('Temp')+'\FV'+intToStr(random(9999));
sintWriteln('Informe um nome para o disco (at 11 letras):');
sintEdita(dkname,wherex,wherey,11,true);
mkdir(dir);
cabecalho;
NoMenu:=true;
Struct:=TStringList.Create;
ArquivosSelecionados:=TStringList.Create;
while NoMenu do CDDOpcoes;
end;

{ Fecha Handle do disco }

procedure FechaCDHandle;
begin
CloseHandle(hDevice);
end;

{ Copia um Ddisco }

procedure CopiaDisco;
var
CDSector: TCD8K;
DkName: string;
    arq: file of Byte;
    dksize, total: int64;
    c: char;
    porc: real;
begin
total:=0;
cabecalho;
mensagem('FVCPD1');writeln;
if (StatusDisco(DriveNum(ProcuraDrive)))<=0 then
begin
sintWriteln('No h nenhum disco na unidade '+ProcuraDrive+':');
sintWriteln('Por favor, insira um disco legvel na unidade '+ProcuraDrive);
exit;
end;
mensagem('FVCPD2');
dkName:=DiskLabel(ProcuraDrive);
sintEdita(dkName,wherex,wherey,255,true);
dkName:=dkName+'.iso';
dkName:=cfg.DirSaida+'\'+dkName;
    mensagem('FVCPD3'); writeln;
cabecalho;
mensagem('FVCPD4');
writeln;
    mensagem('FVCPD5'); sintWriteln(diskLabel(ProcuraDrive));
    mensagem('FVCPD6'); sintWriteln(dkName);
dksize:=disksize(DriveNum(ProcuraDrive));
    mensagem('FVCPD7'); sintWriteln(inttostr(dksize div 1024 div 1024)+' MB');
{$I-}
assign(arq,dkname);
rewrite(arq);
if not AbreCDHandle then
begin
    mensagem('FVCPD8');
exit;
end;
    SetFilePointer(hDevice,0,nil,FILE_BEGIN);
    mensagem('FVCPD9');
    clrscr;
    SetWindowText(crtWindow,pchar('Formatvox - Copiando disco '+diskLabel(ProcuraDrive)));
    repeat
    if keypressed then c:=upcase(readkey);
if c=#27 then
begin
sintWriteln('Deseja cancelar a cpia?');
c:=readkey;
sintCarac(c);
c:=upcase(c);
if c='S' then
begin
close(arq);
DeleteFile(pchar(dkname));
sintWriteln('Operao cancelada.');
exit;
end;
end;
    if c>#0 then
    begin
    porc:=total/dksize*100;
    cabecalho;
    sintWriteln(copy(floattostr(porc),1,4)+'% concluido, '+inttostr(total div 1024 div 1024)+' MB de '+inttostr(dksize div 1024 div 1024)+' MB copiados.');
    end;
    c:=#0;
    CDSector:=RDCD8K;
    total:=total+BUFSIZE;
    blockwrite(arq,CDSector,btsIO);
    until btsIO<BUFSIZE;
    FechaCDHandle;
    Close(arq);
    Cabecalho;
    EjetaCD;
    mensagem('FVCPD10');
end;

{ Menu de opes para gravao de discos }

function GravacaodeDiscos: boolean;
function MenuDiscos: integer;
var
n: integer;
begin
PopUpMenuCria(wherex,wherey,58,10,MAGENTA);
PopUpMenuAdiciona('FVGDOP1','  A - Apagar disco regravvel');
PopUpMenuAdiciona('FVGDOP2','  C - Copiar um disco');
PopUpMenuAdiciona('FVGDOP3','  D - Criar disco de dados ou udio');
PopUpMenuAdiciona('FVGDOP4','  I - Gravar imagem em disco');
MenuDiscos:=PopUpMenuSeleciona;
end;

const
opcoes='ACDI';

var
op,op2: char;
item: integer;
opcao: char;
begin
cabecalho;
TituloPadrao;
mensagem('FVDISCOS');
writeln;
if not VerificaCDBXP then
begin
sintWriteln('Aviso: Esta funcionalidade requer a instalao do');
sintWriteln('programa de gravao de discos CDBurnerXP.');
GravacaodeDiscos:=false;
exit;
end;
textBackGround(BLUE);
mensagem('FVQUOP');
TextBackGround(Black);
sintLeTecla(op,op2);
if (op2=CIMA) or (OP2=BAIX) then
begin
item:=MenuDiscos;
if item=0 then exit;
opcao:=opcoes[item];
end
else
opcao:=UpCase(op);

case op of
#27:
begin
GravacaodeDiscos:=false;
exit;
end;
end;
case upcase(opcao) of
'A': ApagaDisco;
'C': CopiaDisco;
'D': CriaDiscodeDados;
'I': GravaImagemDisco;
else
begin
mensagem('FVOPINV'); {'Opo invlida.'}
mensagem('FVAJCONOP'); {'Use as setas para conhecer as opes.'}
end;
end;
end;

{ Verifica se o CDBurnerXP est instalado }

function VerificaCDBXP: boolean;
begin
VerificaCDBXP:=false;
PathCDBXP:=GetEnvironmentVariable('ProgramFiles');
PathCDBXP:=PathCDBXP+'\CDBurnerXP\';
if DirectoryExists(PathCDBXP) then
VerificaCDBXP:=true
else
VerificaCDBXP:=false;
end;

{ Executa uma funo com o CDBurnerXP }

procedure ExecutaCDBXP(params: string);
var cmd: string;
begin
cmd:=PathCDBXP+'cdbxpcmd.exe';
shellexecute(hwnd(0),pchar('open'),pchar(cmd),pchar(' '+params),pchar(''),0);
while processExists('cdbxpcmd.exe') do
begin
sintClek;
delay(1000);
end;
end;

{ Ejeta drive de CD }

procedure EjetaCD;
begin
ExecutaCDBXP('--eject');
end;

end.
