{ Formatvox - Mdulo de converso de arquivos
{ Por Lucas Alexandre
{ Em Maio/2015 }

unit fvconvert;

interface

uses classes, dvArq, dvCrt, dvWin, fvArq, fvdvd, fvmsg, mmsystem, sysUtils, Windows, fvutils;

procedure ConverteUmArquivo;
procedure ConverteUmDiretorio;
procedure ConverteUmDVD;
procedure CapturaStreaming;
procedure DivideUmArquivo;
procedure ConfAudio; forward;
function FormataVolume(volume: string): string;

implementation

uses dvForm, FileCtrl, fvcfg, fvdiscos, mftdirs, ShellAPI;

type
tConfs = record
bitrate: string[3];
canais: string[2];
samples: string[6];
volume: string[3];
end;

const
FMTCONFAUDIO='MP3 WAV WMA AAC OGG FLAC'; { Formatos de arquivo de udio que permitem configurao }

var
confs: tConfs;
fmtAudio: array[1..9] of string[4] = (
 'MP3','WAV','WMA','AAC','OGG','M4A','CAF','AMR','FLAC'
);

fmtVideo: array[1..10] of string[4] = (
    'AVI', '3GP', 'FLV', 'MP4', 'MKV', 'WMV', 'MOV', 'MPG', 'M4V','RMVB'
    );

    fmtImagem: array[1..4] of string = (
    'JPG', 'BMP', 'GIF', 'PNG'
    );

{ Checa se um formato requer configuraes }

function ChecaConfFormato(f: string): boolean;
begin
f:=AnsiUpperCase(f);
if pos(f,FMTCONFAUDIO)<>0 then
ChecaConfFormato:=true
else
ChecaConfFormato:=false;
end;

{ Define parmetros de udio em uma linha de comando }

procedure ParametrosAudio(var cmd: string);
begin
cmd:=cmd+'-ab '+confs.bitrate+'k -ac '+confs.canais+' -ar '+confs.samples+' -af "volume='+formataVolume(confs.volume)+'" ';
end;

{ Configuraes de um formato de udio }

procedure ConfAudio;
var
bitrate, canais, samples, volume: string;
begin
bitrate:='128';
canais:='2';
samples:='44100';
volume:='100';
cabecalho;
mensagem('FVCONFAUD'); {'Configuraes do formato de udio'}
writeln;
mensagem('FVKBITS');
sintEdita(bitrate,wherex,wherey,4,true);
writeln;
mensagem('FVQCHAN');
sintEdita(canais,wherex,wherey,2,true);
writeln;
mensagem('FVISAMPLES');
sintEdita(samples,wherex,wherey,6,true);
sintWriteln('Informe o volume desejado de 0 a 100');
sintWriteln('Valores superiores a 200 podem danificar o arquivo de sada');
sintEdita(volume,wherex,wherey,6,true);
confs.bitrate:=bitrate;
confs.canais:=canais;
confs.samples:=samples;
confs.volume:=volume;
end;

{ Seleciona o tipo de formato }

function SelecionaFormato: string;
function SelecionaFormatoAudio: string;
var i: integer;
formato: integer;
begin
cabecalho;
mensagem('FVSELECFMT'); {'Selecione um formato'}
PopUpMenuCria(1,5,3,9,BLACK);
for i := 1 to 9 do PopUpMenuAdiciona('',fmtAudio[i]);
formato:=PopUpMenuSeleciona;
SelecionaFormatoAudio:=fmtAudio[formato];
end;

function SelecionaFormatoVideo: string;
var i: integer;
formato: integer;
begin
cabecalho;
mensagem('FVSELECFMT'); {'Selecione um formato'}
PopUpMenuCria(wherex,wherey,3,9,BLACK);
for i := 1 to 10 do PopUpMenuAdiciona('',fmtVideo[i]);
formato:=PopUpMenuSeleciona;
SelecionaFormatoVideo:=fmtVideo[formato];
end;

function SelecionaFormatoImagem: string;
var i: integer;
formato: integer;
begin
cabecalho;
mensagem('FVSELECFMT'); {'Selecione um formato'}
PopUpMenuCria(wherex,wherey,3,9,BLACK);
for i := 1 to 4 do PopUpMenuAdiciona('',fmtImagem[i]);
formato:=PopUpMenuSeleciona;
SelecionaFormatoImagem:=fmtImagem[formato];
end;

var
 tipo: integer;
formato: string[4];
begin
cabecalho;
PopUpMenuCria(1,5,10,2,BLACK);
PopUpMenuAdiciona('','udio');
PopUpMenuAdiciona('','Vdeo');
PopUpMenuAdiciona('','Imagem');
tipo:=PopUpMenuSeleciona;

if tipo=1 then
begin
formato:=SelecionaFormatoAudio;
SelecionaFormato:=formato;
end
else
if tipo=2 then
begin
formato:=SelecionaFormatoVideo;
SelecionaFormato:=formato;
end
else
if tipo=3 then
begin
formato:=SelecionaFormatoImagem;
SelecionaFormato:=formato;
end;
end;

{ Formata volume em valor flutuante }

function FormataVolume(volume: string): string;
var s: string;
i: real;
begin
i:=strToInt(volume)/100;
s:=copy(floatToStr(i),1,4);
if length(s)=3 then s:=s+'0';
if length(s)=1 then s:=s+'.0';
s[2]:='.';
formataVolume:=s;
end;

{ Converte um arquivo para outro formato }

procedure ConverteUmArquivo;
var nomeArq1,nomeArq2: string; formato: string[3];
c: char;
begin
cabecalho;
mensagem('FVCONVARQ');
writeln;
mensagem('FVNOMEARQ');
GaranteEspacoTela(10);
nomeArq1:=ObtemNomeArq(10);
if ChecaNomeArq(nomeArq1) then
begin
nomeArq2:=nomeArq1;
if (pos('\',nomeArq1))<>0 then
nomeArq2:=PegaNomeArq(nomeArq1);
nomeArq2:=RemoveExtensao(nomeArq2);
writeln;
mensagem('FVEDITARQ');
sintEdita(nomeArq2,wherex,wherey,103,true);
cabecalho;
mensagem('FVSELDEST'); {'Selecione o formato de destino para a converso'}
formato:=SelecionaFormato;
formato:=AnsiLowercase(formato);
if ChecaConfFormato(formato) then ConfAudio;
cabecalho;
mensagem('FVOKCONV'); {'Ok, a converso ser iniciada. Por favor, aguarde'}
with confs do
begin
cmd:='-i "'+nomearq1+'" ';
if ChecaConfFormato(formato) then
ParametrosAudio(cmd);
cmd:=cmd+'"'+cfg.dirSaida+'\'+nomeArq2+'.'+formato+'"';
if not execFFMpeg(cmd,nomeArq1) then
begin
DeleteFile(pchar(cfg.dirSaida+'\'+nomeArq2+'.'+formato));
exit;
end;
end;
cabecalho;

if fileExists(cfg.dirSaida+'\'+nomeArq2+'.'+formato) then
begin
sintSom('e_end');
sintWriteln('Converso concluda com sucesso.');
sintWriteln('O arquivo '+nomeArq2+'.'+formato+' foi convertido e salvo em '+cfg.dirSaida+'.');
repeat
sintWriteln('Deseja reproduzir o arquivo?');
c:=upcase(sintReadkey);
if c='S' then
begin
sintWriteln('Reproduzindo; para parar, pressione ESC.');
execArquivo(cfg.dirSaida+'\'+nomeArq2+'.'+formato);
end;
until (c='N') or (c='S');
end
else
begin
mensagem('FVERRCONV'); {'Erro na converso'}
end;

end
else
exit;
end;

{ Converte um diretrio }

procedure ConverteUmDiretorio;
var
lista: TStringList;
ContemOrigem: boolean;
c: char;
arqconv, arqsaida, tdir, Destino, nomeDIr, origem: string;
i,j: integer;
begin
cabecalho;
mensagem('FVCONVDIR');
writeln;
mensagem('FVNOMEDIR');
sintReadln(NomeDir);
if NomeDir='' then nomeDir:=SelecionaPreferido;
if nomeDir = '' then exit;
if not DirectoryExists(nomeDir) then
begin
mensagem('FVINDIR');
exit;
end;
chdir(nomedir);
cabecalho;
mensagem('FVSELORIG'); {'Selecione o formato de origem'}
origem:=selecionaformato;
mensagem('FVSELDEST'); {'Selecione o formato de destino'}
cabecalho;
destino:=selecionaformato;
if ChecaConfFormato(destino) then ConfAudio;
lista:=TStringList.Create;
GetDriveStructure(nomeDir,lista);
if lista.Count=0 then
begin
sintWriteln('Diretrio vazio. Sinto muito.');
exit;
end;
j:=0;
for i:=0 to lista.Count-1 do
if (pos(AnsiLowerCase('.'+origem),AnsiLowerCase(lista[i]))<>0) then
begin
ContemOrigem:=true;
inc(j);
end;
if (origem='RMVB') and (fileExists('*.rm')) then ContemOrigem:=true;
cabecalho;
if not ContemOrigem then
begin
sintWriteln('No foi encontrado nenhum arquivo do tipo '+origem+' neste diretrio.');
exit;
end;
nomeDir:=PegaNomeArq(nomeDir);
mensagem('FVEDITDIR');
sintEdita(NomeDir,wherex,wherey,80,true);
if pos('\',nomeDir)<>0 then
begin
sintWriteln('Diretrio dve ser um nome sem caminho absoluto.');
exit;
end;
mensagem('FVCVND'); sintwrite(inttostr(j)); mensagem('FVNARQVS');
mensagem('FVOKCONV');
origem:=AnsiLowerCase(origem);
destino:=AnsiLowerCase(destino);
for i:=0 to lista.Count-1 do
begin
if (pos(AnsiLowerCase('.'+origem),AnsiLowerCase(lista[i]))<>0) then
begin
sintClek;
tdir:=PegaCaminhoArq(lista[i]);
tdir:=cfg.dirsaida+copy(tdir,3,length(tdir));
try
if not DirectoryExists(tdir) then
winExec(pchar('cmd /c mkdir "'+tdir+'"'),SW_HIDE);
Except
sintWriteln('Um erro inesperado est impedindo a criao do diretrio: ');
sintWriteln(tdir);
end;
cmd:='-y -i "'+lista[i]+'" ';
if ChecaConfFormato(destino) then parametrosAudio(cmd);
arqsaida:=RemoveExtensao(pegaNomeArq(lista[i]))+'.'+AnsiLowerCase(destino);
cmd:=cmd+'"'+tdir+'\'+arqsaida+'"';
if not execFFMPEG(cmd,pegaNomeArq(lista[i])) then
begin
mensagem('FVOPINT'); {'Operao foi interrompida'}
mensagem('FVDESCAN'); {'Deseja cancelar a converso?'}
c:=sintReadkey;
if upcase(c)='S' then exit;
end;
end;
end;
chdir(FVDIR);
lista.Free;
cabecalho;
sintWriteln('Converso bem sucedida!');
sintWriteln(inttostr(j)+' arquivos foram convertidos e salvos em "'+cfg.dirsaida+'".');
end;

{ Converte um DVD para outro formato }

procedure ConverteUmDVD;
var
erro: integer;
diskname,formato: string;
DVDSearch: TSearchRec;
unid: char;
begin
cabecalho;
sintWriteln('Converter um DVD');
writeln;
{$I-}
unid:=ProcuraDrive;
if (StatusDisco(DriveNum(unid)))=-1 then
begin
sintWriteln('No h disco presente nesta unidade.');
exit;
end;
if not DirectoryExists(unid+':\VIDEO_TS') then
begin
sintWriteln('No foi possvel encontrar um disco de vdeo nesta unidade.');
sintWriteln('Verifique se o disco est presente na unidade.');
exit;
end;
chdir(unid+':\VIDEO_TS');
cabecalho;
mensagem('FVSELDEST');
formato:=selecionaformato;
if ChecaConfFormato(formato) then ConfAudio;
diskname:=DiskLabel(unid);
cabecalho;
sintWriteln('O disco '+diskname+' foi encontrado.');
sintWriteln('Edite o nome de sada do disco (Enter mantm padro):');
sintEdita(diskname,wherex,wherey,80,true);
diskname:=cfg.dirSaida+'\'+diskname+'.VOB';
assign(DVDFile,diskname);
rewrite(DVDFile);
sintWriteln('Iniciando a extrao do disco. Isso pode levar alguns minutos.');
findfirst('*.VOB',faArchive,DVDSearch);
while erro=0 do
begin
if (DVDSearch.Name<>'VIDEO_TS') and (pos('_0.VOB',DVDSearch.Name)=0) then
AddVOB(unid+':\VIDEO_TS\'+DVDSearch.Name);
erro:=findnext(DVDSearch);
end;
close(DVDFile);
EjetaCD;
sintSom('e_end');
sintWriteln('Extrao do disco foi concluda com sucesso.');
writeln;
sintWriteln('Convertendo disco para o formato '+formato+', por favor, aguarde.');
{$I+}
cmd:='-i "'+diskname+'" ';
if ChecaConfFormato(formato) then
begin
ConfAudio;
parametrosAudio(cmd);
end;
cmd:=cmd+'"'+RemoveExtensao(diskname)+'.'+formato+'"';
if not execFFMPEG(cmd) then
begin
sintWriteln('Erro na converso do disco.');
sintWriteln('Operao cancelada.');
end;
end;

{ Divide um arquivo }

procedure DivideUmArquivo;
var
cmd: string;
formato: string;
nomeArq: string;
tempo1, tempo2: string;
begin
cabecalho;
sintWriteln('Dividir um arquivo');
writeln;
sintWriteln('Informe o nome do arquivo a dividir: ');
GaranteEspacoTela(10);
nomeArq:=ObtemNomeArq(10);
if not ChecaNomeArq(nomeArq) then exit;
writeln;
sintWriteln('Informe o tempo de incio do arquivo no formato hh:mm:ss:');
sintWriteln('Exemplo: 00:00:20 - Arquivo iniciar a partir dos 20 segundos');
sintReadln(tempo1);
if (length(tempo1)<>8) then
begin
sintWriteln('Formato de tempo incorreto.');
exit;
end;
sintWriteln('Informe o tempo final do arquivo no formato hh:mm:ss:');
sintReadln(tempo2);
if (length(tempo2)<>8) then
begin
sintWriteln('Formato de tempo incorreto.');
exit;
end;
cabecalho;
sintWriteln('Selecione o formato de destino do arquivo:');
formato:=selecionaformato;
cmd:='-t '+tempo2+' -i "'+nomeArq+'"';
if checaConfFormato(formato) then
begin
ConfAudio;
parametrosAudio(cmd);
end;
cmd:=cmd+' -ss '+tempo1+' "'+cfg.DirSaida+'\'+RemoveExtensao(PegaNomeArq(nomeArq))+'.'+AnsiLowerCase(formato)+'"';
sintWriteln('Dividindo e salvando arquivo, por favor, aguarde.');
if not ExecFFMPEG(cmd) then
begin
sintWriteln('Erro na diviso.');
exit;
end;
cabecalho;
sintSom('e_end');
sintWriteln('Operao foi concluda.');
end;

{ Captura streaming para arquivo }

procedure CapturaStreaming;
var link, nomeArq: string;
c: char;
formato: string;
begin
cabecalho;
mensagem('FVCS1');
writeln;
mensagem('FVCS2');
sintReadln(link);
if link='' then
begin
mensagem('FVDESIST');
exit;
end;
sintWriteln('Informe o nome do arquivo contendo a captura:');
sintReadln(nomeArq);
if nomeArq='' then
begin
mensagem('FVDESIST');
exit;
end;
cabecalho;
sintWriteln('Selecione um formato de destino para o arquivo');
formato:=AnsiLowerCase(selecionaFormato);
nomeArq:=nomeArq+'.'+formato;
writeln;
repeat
sintWriteln('Deseja reproduzir o udio durante a captura?');
c:=upcase(sintReadKey);
until (c='S') or (c='N');
cabecalho;
sintWriteln('Iniciando captura. Para terminar, pressione ESC.');
if c='S' then shellExecute(hwnd(0),pchar('open'),pchar('C:\winvox\ffplay.exe'),pchar(' '+link),pchar(''),0);
execFFMpeg('-y -i '+link+' "'+nomeArq+'"');
MataProcesso('ffplay.exe');
sintWriteln('Captura finalizada.');
if not fileExists(nomeArq) then
begin
sintWriteln('Erro na captura.');
sintWriteln('Servidor de streaming pode estar indisponvel.');
end
else
sintWriteln('Streaming capturado com sucesso.');
end;

end.
