{ Formatvox - Mdulo de configuraes
{ Por Lucas Alexandre
{ Em Maio/2015 }

unit fvcfg;

interface

uses dvCrt, dvWin, FileCtrl, fvmsg, sysUtils, Windows;

var
FVDIR: string;

function configuracoes(s: string): boolean;
function CarregaConf(s: string): boolean;

type
tCfg = packed record
hdr: string[5];
dirSaida: string[255];
end;

const
CFGHDR='FVCFG';

var
cfg: tCfg;

implementation

uses fvutils;

{ Verifica se um diretrio novo existe }

function ChecaNovoDir(nomeDir: string): boolean;
var c: char;
begin
if directoryexists(nomeDir) then
begin
cfg.dirSaida:=nomeDir;
ChecaNovoDir:=true;
end
else
begin
mensagem('FVDIRNAOCRI'); {'Diretrio no existe, devo cri-lo?'}
c:=readkey;
sintCarac(c);
if upcase(c)='S' then
begin
 mkdir(nomeDir);
if directoryExists(nomeDir) then  cfg.dirSaida:=nomeDir;
ChecaNovoDir:=true;
exit;
end
else
exit;

if not fileExists(nomeDir) then
begin
mensagem('FVERRCRDIR'); {'Erro na criao do diretrio'}
exit;
end;
end;
end;

{ Carrega o arquivo de configurao }

function Carregaconf(s: string): boolean;
var
Arqcfg: file of tCfg;
begin
carregaConf := false;
assign(arqcfg, s);
{$I-} reset(arqcfg); {$I+}
if IOResult <> 0 then
begin
mensagem('FVERRLEIT'); {'Erro na leitura dos dados'}
exit;
end;
{$I-} read(arqcfg,cfg); {$I+}
if IOResult <> 0 then
begin
mensagem('FVERRLEIT'); {'Erro na leitura dos dados'}
exit;
end;
close(arqcfg);
carregaConf := true;
end;

{ Configura o Formatvox }

function configuracoes(s: string): boolean;
var nomeDir: string;
Arqcfg: file of tCfg;
begin
configuracoes := false;
while true do
begin
cabecalho;
mensagem('FVCSAIDA');
nomeDir:=cfg.dirSaida;
sintEdita(nomeDir,wherex,wherey,255,true);
writeln;
if nomeDir='' then terminar;
if nomeDir[length(nomeDir)] = '\' then nomeDir[length(nomeDir)]:=' ';
if ChecaNovoDir(nomeDir) then break;
end;
assign(arqcfg, s);
{$I-} rewrite(arqcfg); {$I+}
if IOResult <> 0 then
begin
mensagem('FVERRESC'); {'Erro na escrita dos dados'}
exit;
end;
{$I-} write(arqcfg,cfg); {$I+}
if IOResult <> 0 then
begin
mensagem('FVERRESC'); {'Erro na escrita dos dados'}
exit;
end;
close(arqcfg);
mensagem('FVCONFSAV'); {'Configuraes foram salvas'}
configuracoes := true;
end;

{ Define dados de configurao }

begin
cfg.hdr:=CFGHDR;
end.
