{ Formatvox - Informaes gerais
{ Por Lucas Alexandre
{ Em Maio/2015 }

unit fvinfo;

interface

uses dvCrt, dvWin, sysUtils, windows;

procedure sobre;
procedure InfoArquivo;

implementation

uses fvutils, fvvars;

procedure infoMP3(nomeArq: string); forward;

{ Sobre o Formatvox }

procedure sobre;
begin
cabecalho;
sintWriteln('Formatvox - Conversor multimdia - Verso '+versao);
writeln;
sintWriteln('Crditos');
writeln;
sintWriteln('Lucas Alexandre (desenvolvedor e programador)');
sintWriteln('Eduardo Maidana (distribuio vocal)');
writeln;
sintWriteln('Pgina do Formatvox na Web:');
sintWriteln('http://www.lucaspcs.com.br/2017/12/23/formatvox/');
writeln;
sintWriteln('Em caso de dvida, sugesto, crtica ou reporte de bugs, envie um e-mail');
sintWriteln('para os seguintes endereos: ');
writeln;
sintwriteln('lucasalexandre.bp@gmail.com');
sintWriteln('lucas@lucaspcs.com.br');
end;

{ Apresenta informaes de um arquivo }

procedure InfoArquivo;
var
extensao, nomeArq: string;
begin
cabecalho;
sintWriteln('Informaes sobre um arquivo');
writeln;
sintWriteln('Informe o nome de um arquivo:');
sintReadln(nomeArq);
writeln;
if nomeArq='' then exit;
if fileExists(nomeArq) = false then
begin
sintWriteln('Arquivo no existe.');
exit;
end;
extensao:=copy(nomeArq,pos('.',nomeArq)+1,length(nomeArq));
extensao:=AnsiUpperCase(extensao);
if extensao='MP3' then
infoMP3(nomeArq)
else
if extensao='AVI' then
sintWriteln('Vdeo no formato AVI (Audio/video Interleaved)')
else
if extensao='WMA' then
sintWriteln('udio no formato WMA (Windows Media Audio)')
else
if extensao='WMV' then
sintWriteln('Vdeo no formato WMV (Windows Media Video)')
else
if extensao='WAV' then
sintWriteln('udio no formato WAV')
else
if extensao='3GP' then
sintWriteln('Vdeo para dispositivos mveis no formato 3GP')
else
if extensao='MP4' then
sintWriteln('Vdeo no formato MP4')
else
if extensao='VOB' then
sintWriteln('Objeto de vdeo de um DVD no formato VOB')
else
if (extensao='JPG') or (extensao='JPEG') then
sintWriteln('Imagem no formato JPG')
else
if extensao='BMP' then
sintWriteln('Imagem no formato Bitmap (BMP)')
else
if extensao='GIF' then
sintWriteln('Imagem animada no formato GIF')
else
if extensao='PNG' then
sintWriteln('Imagem no formato PNG')
else
if extensao='MKV' then
sintWriteln('Vdeo no formato Matroska (MKV)')
else
if (extensao='RM') or (extensao='RMVB') then
sintWriteln('udio/vdeo no formato Real Media')
else
if extensao='MOV' then
sintWriteln('Vdeo no formato MOV')
else
if extensao='FLV' then
sintWriteln('Vdeo no formato FLV')
else
if extensao='MPG' then
sintWriteln('Vdeo no formato MPEG (MPG)')
else
if extensao='AMR' then
sintWriteln('udio para dispositivos mveis no formato AMR')
else
if extensao='VRO' then
sintWriteln('Objeto de vdeo gravado em MPEG-4')
else
if extensao='OGG' then
sintWriteln('udio no formato OGG')
else
if extensao='M4A' then
sintWriteln('udio para dispositivos Apple (M4A)')
else
if extensao='CAF' then
sintWriteln('udio para dispositivos Apple (CAF)')
else
if extensao='FLAC' then
sintWriteln('udio no formato FLAC')
else
if extensao='AAC' then
sintWriteln('udio no formato AAC')
else
sintWriteln('Formato de arquivo desconhecido.');
end;

{ Informaes sobre um arquivo MP3 }

procedure infoMP3;
type
tHdr = packed record
tag: array [0..2] of Char;
    Titulo, Artista, Comentarios: array[0..29] of Char;
    Ano: array[0..3] of Char;
    Album: array[0..29] of Char;
    Genero: byte;
    end;
var
arq: file of byte;
hdr: tHdr;
begin
assign(arq,nomeArq);
reset(arq);
seek(arq,filesize(arq)-128);
blockread(arq,hdr,128);
sintWriteln('Arquivo de udio MP3');
writeln;
if (copy(hdr.tag,1,3))<>'TAG' then
begin
sintWriteln('Informaes do arquivo no esto disponveis.');
exit;
end;
sintWriteln('Informaes sobre o arquivo');
writeln;
if hdr.titulo<>'' then sintWriteln('Ttulo: '+hdr.titulo);
if hdr.artista<>'' then sintWriteln('Artista: '+hdr.artista);
if hdr.ano<>'' then sintWriteln('Ano: '+hdr.ano);
if hdr.comentarios<>'' then sintWriteln('Comentrios: '+hdr.comentarios);
close(arq);
end;
end.
