{ Formatvox - Manipulao de DVD em baixo nvel }
{ Por Lucas Alexandre
{ Em Junho/2015 }

unit fvdvd;
interface
var
DVDFile: file of Byte;
procedure AddVOB(path: string);
function DiskLabel(letter: char): string;
function ProcuraDrive: char;
function DriveNum(letter: char): integer;
function StatusDisco(DiskNum: integer): integer;
implementation
uses sysUtils, windows;
var
VOBFile: file of Byte;
procedure AddVOB(path: string);
type
tBuffer=^Buffer;
buffer=array[0..65535] of byte;
var
buf: tBuffer;
rd: integer;
begin
if not fileExists(path) then exit;
new(buf);
assign(VOBFile,path);
{$I-}
reset(VOBFile);
while not eof(VOBFile) do
begin
blockread(VOBFile,buf^,sizeof(buf^),rd);
blockwrite(DVDFile,buf^,sizeof(buf^),rd);
end;
close(VOBFile);
end;

{ Descobre nome de um disco }

function DiskLabel(letter: char): string;
var
DType: byte;
Dummy: DWord;
Volume: array[0..29] of char;
begin
DType:=GetDriveType(pchar(letter+':\'));
GetVolumeInformation(pchar(letter+':\'),volume,sizeof(volume),nil,dummy,dummy,nil,0);
if strPas(volume)='@' then
diskLabel:='desconhecido'
else
DiskLabel:=strPas(volume);
end;

{ Procura drive ptico primrio }

function ProcuraDrive: char;
var
i: char;
begin
for i:='A' to 'Z' do
if (GetDriveType(pchar(i+':\')))=Drive_CDROM then ProcuraDrive:=i;
end;

{ Retorna nmero de uma unidade }

function DriveNum(letter: char): integer;
begin
DriveNum:=ord(letter)-ord('A')+1;
end;

{ Verifica o status de um disco no Drive }

function StatusDisco(DiskNum: integer): integer;
begin
StatusDisco:=disksize(DiskNum);
end;

end.
