{
{ Formatvox - Conversor multimdia
{ Por Lucas Alexandre
{
{ Verso 1.0 em Fevereiro/2014
{ Verso 2.0A em Setembro/2014
{ Verso 2.0B em Novembro/2014
{ Verso 2.1 em Agosto/2015 }
{ Verso 6.9.15 em Setembro/2015 }
{ Verso 2.11 em Novembro/2016 }
{ Verso 2.12 em Dezembro/2016 }
{ Verso 3.04 em Abril/2017 }
{ Verso 4.6 em Junho/2018 }

program formatvox;

uses
classes, mftdirs, dvCrt, dvForm, dvWin, sysUtils, windows,
fvcfg, fvconvert, fvdiscos, fvinfo, fvmsg, fvutils, fvvars;

{ fim do programa }

procedure fim;
var c: char;
begin
mensagem('FVCFIM'); {'Confirma fim?'}
c:=sintReadKey;
writeln;
if upcase(c)='S' then
begin
terminar;
end
else
exit;
end;

{ Opes principais do Formatvox }

procedure opcoes;
function menuprincipal: integer;
begin
PopUpMenuCria(wherex,wherey,58,10,MAGENTA);
PopUpMenuAdiciona('FVOP1','  C - Converter um arquivo');
PopUpMenuAdiciona('FVOP2','  D - Converter um diretrio');
PopUpMenuAdiciona('FVOP3','  F - Converter DVD para outro formato');
PopUpMenuAdiciona('FVOP4','  G - Gravao de discos');
PopUpMenuAdiciona('FVOP5','  I - Informaes sobre um arquivo multimdia');
PopUpMenuAdiciona('FVOP6','  M - Alterar diretrio de sada');
PopUpMenuAdiciona('FVOP10','  R - Capturar streaming em arquivo');
PopUpMenuAdiciona('FVOP7','  S - Dividir um arquivo');
PopUpMenuAdiciona('FVOP8','  F2 - Sobre o Formatvox');
PopUpMenuAdiciona('FVOP9','  ESC - Fim do programa');
menuprincipal:=PopUpMenuSeleciona;
end;

const
LetraOp: string[10]='cdfgimrs12';

var
opcao, op,op2: char;
nop: integer;

begin
cabecalho;
textBackground(Blue);
mensagem('FVQUOP'); {'Qual sua opo ? '}
textBackground(Black);
sintLeTecla(op,op2);

writeln;

if (op2=BAIX) or (op2=CIMA) then
begin
nop:=menuprincipal;
if nop=0 then exit;
if (nop>0) and (nop<=10) then opcao:=LetraOp[nop];
if opcao='1' then opcao:=#60;
end
else
opcao:=op;

if op2='1' then opcao:=#60;

        if (op=ENTER) or (op=' ') then exit;
if ord(opcao)=50 then op2:=#27;

case (op2) of
#60: sobre;
#27: fim;
else
case upcase(opcao) of
'C': ConverteUmArquivo;
'D': ConverteUmDiretorio;
'F': ConverteUmDVD;
'G': while GravacaodeDiscos do;
'I': InfoArquivo;
'M': Configuracoes(config);
'R': CapturaStreaming;
'S': DivideUmArquivo;
#27: fim;
#60: sobre;
else
if nop=10 then fim;
begin
mensagem('FVOPINV');
mensagem('FVAJCONOP');
end;
end;
end;
end;

{ Inicializao }

procedure inicializa;
var ambiente: string;
begin
    ambiente := sintambiente('FORMATVOX', 'DIRFORMATVOX');
    if ambiente = '' then
        ambiente := 'c:\winvox\som\formatvox';
FVDIR := ambiente;
sintInic(0,ambiente);
TituloPadrao;
textBackground(Blue);
mensagem('FVINIC');
sintSoletra(VERSAO);
textBackground(Black);
writeln;
ambiente := sintAmbiente('FORMATVOX', 'ARQCONFIG');
if ambiente = '' then ambiente := 'formatvox.cfg';
if fileExists(ambiente) then
begin
if not CarregaConf(ambiente) then terminar;
end
else
begin
mensagem('FVCONFIG'); writeln;
if not configuracoes(ambiente) then terminar;
end;
config := ambiente;
end;

var
principal: boolean;
begin
inicializa;
if not verificaFFMpeg then
begin
sintBip; sintBip; sintBip; sintBip;
mensagem('FVFFMNAOACH'); {'FFMpeg no achado'}
mensagem('FVPORDOS'); {'Verifique a configurao do Formatvox no dosvox.ini'}
while sintfalando do delay(10);
terminar;
end;
mensagem('FVAJSELOP');
writeln;
principal:=true;
while principal do opcoes;
DoneWinCrt;
end.
