{--------------------------------------------------------}
{
{    Manipulacao da area de transferencia
{
{    Autor: Antonio Borges
{
{    Em 27/01/98
{
{--------------------------------------------------------}

Unit edTransf;

interface
uses
    DVcrt, DVWin,
    edVars, edMensag, edLinha;

procedure jogaAreaTransf (falando: boolean);
procedure pegaAreaTransf (falando: boolean);

implementation

{--------------------------------------------------------}

procedure jogaAreaTransf (falando: boolean);
var i: integer;
    p: PChar;
    pos, tam: word;
begin
    if (inibloco <= 0) or (fimbloco < inibloco) then
        fala ('EDBLKINV')
    else
        begin
            getmem (p, 65000);
            pos := 0;
            for i := iniBloco to fimBloco do
                begin
                    tam := length (texto^[i]^);
                    if (longint (pos) + tam + 2) > 65000 then
                        begin
                            fala ('EDCOPTRU');   {cpia truncada}
                            break;
                        end;
                    move (texto^[i]^[1], p[pos], tam);
                    pos := pos + tam;
                    p[pos]   := #$0d;
                    p[pos+1] := #$0a;
                    pos := pos + 2;
                end;
            p[pos] := #$0;

//            if falando then
                fala ('EDBLKCRG');   {'Bloco carregado'}
//            else
//                sintClek;
            putClipboard (p);

            freemem (p, 65000);
        end;
end;

{--------------------------------------------------------}

procedure pegaAreaTransf (falando: boolean);
var
    i: integer;
    s: string;
    buf: PChar;

Begin
    iniBloco := posy;
    fimBloco := posy;

    getmem (buf, 65000);
    getClipboard (buf, 65000);

    i := 0;
    while (posy < MAXLINHASTEXTO) and (buf[i] <> #$0) do
      begin
         s := '';
         while (buf[i] <> #$0a) and (buf[i] <> #$0) do
             begin
                 if buf[i] <> #$0d then
                      s := s + buf[i];
                 if (length (s) >= 120) and (buf[i] = ' ') then
                      break;

                 i := i + 1;
             end;

         if buf[i] <> #$0 then
            i := i + 1;

         insereLinha (s, false);
         posy := posy + 1;
      end;

    posx := 1;
    fimbloco := posy-1;
    freemem (buf, 65000);

    if posy >= MAXLINHASTEXTO then
        fala ('EDBLKTRN')   {bloco truncado}
    else
//        if falando then
            fala ('EDBLKADC');  {'Bloco adicionado'}
//    else
//        sintClek;
end;

end.
