{    Programa de Consulta  Dicionrios             }
{    Autor:  Glauco Frius Constantino de Oliveira     }
{    Orientador: Marcelo Pimentel
{    Rio de Janeiro, 18 de fevereiro de 1995    }

Program Dicvox;

Uses DVCRT, WinDOWS, dvHora, DVWin, dvForm, sysUtils,
    DicLeitu, DicVars, Dicfun, Dicfunc, DicSom, DicBusca, Dicler, dicBloco;

Procedure Escrevetela;
begin
  textbackground(blue);
  textcolor (LightGray);
  Clrscr;
  MolduraTela;
  gotoxy(26,2);
  write( 'DICIONRIOS  ELETRNICOS');
  gotoxy(29, 3);
  write ('Verso DOSVOX 3.2 - 2004');
  gotoxy(6, 4);
  Write(' Autor:  Glauco Frius Constantino de Oliveira');
  gotoxy(6, 5);
  write('           Baseado no Biblivox do Paulo Barbosa e  Marcelo Pimentel');
end;

{-----------------------------}

Procedure ajuda1;
begin
  limpabaixo;
  gotoxy(20, 8);
  write ('Ajuda das opes principais do Dicvox:');
  gotoxy(10, 11); write('Opo P: para voc encontrar os verbetes.');
  gotoxy(10, 12); write('Opo L: para voc abrir o Dicionrio logo no incio.');
  gotoxy(10, 13); write('Opo M: para voc que j colocou marcadores no seu Dicionrio');
  gotoxy(10, 14); write('Opo I: para conhecer algumas informaes sobre o Dicionrio.');
  gotoxy(10, 15); write('Opo F1 ou H: mostra um pequeno texto de ajuda.');
  sintsom('DCAJUDA');
{  msgbaixo('DCTECESC', 'Tecle ESC para voltar ao menu');}
{  repeat until readkey=#27;}
end;

{-----------------------------}

function txtmsg (f: string): string;
begin
    if f = 'DCCFVEL'  then txtmsg := 'Use as setas para selecionar.'
    else
    if f = 'DCVELC'   then txtmsg := 'Velocidade: '
    else
    if f = 'DCFALPON' then txtmsg := 'Falar pontuao: '
    else
    if f = 'DCDICINI' then txtmsg := 'Dicionrio de abertura: '
    else
    if f = 'DCCOMSAP' then txtmsg := 'Com SAPI: '
    else
    if f = 'DCNUMSAP' then txtmsg := 'Nmero SAPI: '
    else
    if f = 'DCVEL'    then txtmsg := 'Velocidade SAPI: '
    else
    if f = 'DCTOM'    then txtmsg := 'Tonalidade SAPI: '
    else
    ;
end;

{-----------------------------}

function primeiraLetra (s: string): char;
begin
    s := trim (s);
    delete (s, 2, 999);
    if s = '' then primeiraLetra := ' '
              else primeiraLetra := upcase (s[1]);
end;

{-----------------------------}

procedure formConfig;
var confPontuacao, confDic, confGra,
    confSapi: shortString;
     velGeral, confTipoSapi, confNum, confVeloc, confTonal: integer;
    parm: array [0..255] of char;
     comSapi: boolean;
    i: integer;
    s: string;
begin

    //Recuperando informaes do DOSVOX.INI

    val (sintAmbiente('DICVOX', 'VELOCIDADE'), velGeral, erro);
    if erro <> 0 then velGeral := 0;
    confPontuacao  := (sintAmbiente('DICVOX', 'FALARPONTUACAO'));
    confDic := (sintAmbiente('DICVOX', 'DICABERT'));
    confGra  := (sintAmbiente('DICVOX', 'GRAVAPROCURA'));

    confSapi       := (sintAmbiente('DICVOX', 'SAPIATIVADO'));

    val (sintAmbiente('DICVOX', 'TIPOSAPI'), confTipoSapi, erro);
    if erro <> 0 then val (sintAmbiente('SERVFALA', 'TIPOSAPI'), confTipoSapi, erro);
    if erro <> 0 then confTipoSapi := 4;

    val (sintAmbiente('DICVOX', 'NUMEROSAPI'), confNum, erro);
    if erro <> 0 then confNum:= 1;
    val (sintAmbiente('DICVOX', 'VELOCIDADESAPI'), confVeloc, erro);
    if erro <> 0 then confVeloc:= 0;
    val (sintAmbiente('DICVOX', 'TONALIDADESAPI'), confTonal, erro);
    if erro <> 0 then confTonal:= 0;

    // Apresentando o formulrio

    textBackground (BLUE);
    writeln;
    fala ('DCPAICON'); {'Painel de configurao'}
    sintBip; sintBip;
    textBackground (BLACK);
    for i := 10 to 25 do
        begin
             gotoxy (1, i);  clreol;
        end;
    gotoxy (1, 10);

    formCria;
    formCampoInt ('DCVELC',   txtmsg('DCVELC')   {'Velocidade: '},         velGeral); {''}
    formCampo    ('DCFALPON', txtmsg('DCFALPON') {'Falar pontuao: '},    confPontuacao, 4); {''}
    formCampo    ('DCDICINI', txtmsg('DCDICINI') {'Dicionrio de abertura: '}, confDic, 4); {''}
    formCampo    ('DCGRAPRO', txtmsg('DCGRAPRO') {'Grava procura? '},    confGra, 4); {''}
    formCampo    ('DCCOMSAP', txtmsg('DCCOMSAP') {'Com SAPI: '},           confSapi, 4); {''}
    formCampoInt ('DCTIPSAP', txtmsg('DCTIPSAP') {'Tipo SAPI (4 ou 5): '}, confTipoSapi); {''}
    formCampoInt ('DCNUMSAP', txtmsg('DCNUMSAP') {'Nmero SAPI: '},        confNum); {''}
    formCampoInt ('DCVEL',    txtmsg('DCVEL')    {'Velocidade SAPI: '},    confVeloc); {''}
    formCampoInt ('DCTOM',    txtmsg('DCTOM')    {'Tonalidade SAPI: '},    confTonal); {''}
    formEdita (true);

    //Efetuando modificaes

    if (velGeral < 0) or (velGeral > 5) then
        velGeral:= 0;

    // gravando DOSVOX.INI

    writePrivateProfileString ('DICVOX', 'VELOCIDADE', pchar(intToStr(velGeral)), 'DOSVOX.INI');
    strpCopy (parm, maiuscAnsi(confPontuacao));
    writePrivateProfileString ('DICVOX', 'FALARPONTUACAO', (parm), 'DOSVOX.INI');
    strpCopy (parm, maiuscAnsi(confDic));
    writePrivateProfileString ('DICVOX', 'DICABERT', (parm), 'DOSVOX.INI');
    strpCopy (parm, maiuscAnsi(confGra));
    writePrivateProfileString ('DICVOX', 'GRAVAPROCURA', (parm), 'DOSVOX.INI');
    strpCopy (parm, maiuscAnsi(confSapi));
    writePrivateProfileString ('DICVOX', 'SAPIATIVADO', (parm), 'DOSVOX.INI');
    writePrivateProfileString ('DICVOX', 'TIPOSAPI', pchar(intToStr(confTipoSapi)), 'DOSVOX.INI');
    writePrivateProfileString ('DICVOX', 'NUMEROSAPI', pchar(intToStr(confNum)), 'DOSVOX.INI');
    writePrivateProfileString ('DICVOX', 'VELOCIDADESAPI', pchar(intToStr(confVeloc)), 'DOSVOX.INI');
    writePrivateProfileString ('DICVOX', 'TONALIDADESAPI', pchar(intToStr(confTonal)), 'DOSVOX.INI');

    fala ('DCAGUARC'); {'Aguarde'}
    sintPara;

    s := sintAmbiente ('DICVOX', 'FALARPONTUACAO');
    if s = '' then
    begin
    sintFalaPont := copy (sintAmbiente ('DICVOX', 'FALARPONTUACAO'), 1, 1) = 'N';
    end
    else
    sintFalaPont := copy (sintAmbiente ('DICVOX', 'FALARPONTUACAO'), 1, 1) <> 'N';
        if sintFalaPont then
begin
  sintFalaPont :=true;
end;

    s := sintAmbiente ('DICVOX', 'GRAVAPROCURA');
    if s = '' then
    begin
    gravaAsProcuras := copy (sintAmbiente ('DICVOX', 'GRAVAPROCURA'), 1, 1) = 'N';
    end
    else
    gravaAsProcuras := copy (sintAmbiente ('DICVOX', 'GRAVAPROCURA'), 1, 1) <> 'N';
        if gravaAsProcuras then
begin
  gravaAsProcuras :=true;
end;

    s := sintAmbiente ('DICVOX', 'GRAVAPROCURA');
    if s = '' then
    begin
    gravaAsProcuras := copy (sintAmbiente ('DICVOX', 'GRAVAPROCURA'), 1, 1) = 'N';
    end
    else
    gravaAsProcuras := copy (sintAmbiente ('DICVOX', 'GRAVAPROCURA'), 1, 1) <> 'N';
        if gravaAsProcuras then
begin
  gravaAsProcuras :=true;
end;

    if confSapi = '' then
        comSapi := primeiraLetra (sintAmbiente ('DICVOX', 'SAPIATIVADO')) = 'S'
    else
        comSapi := primeiraLetra (confSapi) = 'S';

    s := sintAmbiente ('DICVOX', 'VELOCIDADE');
    if (s = '') or (s = '0') then
        s := sintAmbiente ('TRADUTOR', 'VELOCIDADE');
    if s = '' then
        velGeral := 0
    else
        val (s, velGeral, erro);
    sintReinic (velGeral, comSapi, confTipoSapi, confNum, confVeloc, confTonal);

    writeln;
        msgbaixo('DCOK', 'Ok');
    sintBip; sintBip; sintBip;
    escreveTela;
end;

{-----------------------------}

Procedure ConfiguraDicionario(arqini: String);
var
    config: Text;
    i, j, erroval:Integer;
    strAux: String;
    sz: array [0..144] of char;
begin
  codlivro :=1; capituloatual :=1;

    dirDados := sintAmbiente ('DICVOX', 'DADOSDIC');
    if dirDados = '' then
        begin
            dirDados := 'c:\dicvox';
            strPCopy (sz, dirDados);
            writePrivateProfileString('DICVOX', 'DADOSDIC',     sz, 'DOSVOX.INI');
        end;

assign(config, dirDados + '\' + arqini + '\' + arqini + '.ini');
    {$i-} reset(config); {$i+}
If IOResult <> 0  Then
        begin
        msgbaixo('DCNAOCFG', 'No encontrei o arquivo de configurao.');
        halt(1);
        end;

    { comea a ler as configuraes dos dicionrios... }

For i:=0 to 27 Do
    begin
    readln(config, straux);
    j := Pos('=', straux);
    If j > 0 Then
        begin
        nomeLivros^[i] := copy(straux, 1, j - 1);
strAux := CompactaLinha(copy(straux, j + 1, length(straux) - j));
        val(strAux, indice[i], erroval);
        end;
    end;

{ ao final dos livros e indices, vem o tamanho... }
    readln(config, straux);
    j:= Pos('=', straux);
    strAux := copy(straux, j+1, length(straux) - j);
    straux := compactalinha(straux);
    Val(straux, tamanhoDicionario, erroval);

{ l do arquivo o Tamanho da ltima Letra}
    readln(config, straux);
    j:= Pos('=', straux);
    strAux := copy(straux, j+1, length(straux) - j);
    straux := compactalinha(straux);
    Val(straux, TamanhoLetraZ, erroval);

{ l do arquivo o Inicio da ltima Parte do Dicionrio}
    readln(config, straux);
    j:= Pos('=', straux);
    strAux := copy(straux, j+1, length(straux) - j);
    straux := compactalinha(straux);
    Val(straux, InicioUltimaParte, erroval);

{ l do arquivo o Tamanho do arquivo Info }
    readln(config, straux);
    j:= Pos('=', straux);
    strAux := copy(straux, j+1, length(straux) - j);
    straux := compactalinha(straux);
    Val(straux, TamanhoInfo, erroval);

For i:=1 to 26 Do
    begin
    readln(config, straux);
    j := Pos('=', straux);
    If j > 0 Then
        begin
strAux := CompactaLinha(copy(straux, j + 1, length(straux) - j));
        val(strAux, NumeroCap[i], erroval);
        end;
    end;

  dadosDisco := dirDados + '\' + arqini + '\' + arqini + '.dat';
  dadosLinhas := dirDados + '\' + arqini + '\lin_' + arqini + '.dat';
  DadosInfo := dirDados + '\' + arqini + '\inf_' + arqini + '.dat';

   close(Config);
{$i-} close(quelinha); {$i+}
  assign(quelinha, dadoslinhas);
  {$i-} reset(quelinha);{$i+}
  If IOresult <> 0  Then
      write(#7, #7);
end;

{-----------------------------}

Procedure FalaVersao;
var s1: string;

begin
    s1 := sintAmbiente ('DICVOX', 'DICATU');
    if s1 = 'A' then
    begin
        sintWriteLn (' 7.0 '); msgbaixo ('DCLATIM', 'A - Dicionrio Jurdico de Latim');
    end;

    if s1 = 'B' then
    begin
        sintWriteLn (' 7.0 '); msgbaixo ('DCDBAL', 'B - Dicionrio da Bblia de Almeida');
    end;

    if s1 = 'C' then
    begin
        sintWriteLn (' 7.0 '); msgbaixo ('DCSOCI', 'C - Dicionrio de Sociologia');
    end;

    if s1 = 'D' then
    begin
        sintWriteLn (' 7.0 '); msgbaixo ('DCESPPOR', 'D - Espanhol - Portugus');
    end;

    if s1 = 'E' then
    begin
        sintWriteLn (' 7.0 '); msgbaixo ('DCESPA', 'E - Espanhol - Espanhol');
    end;

    if s1 = 'F' then
    begin
        sintWriteLn (' 7.0 '); msgbaixo ('DCFRAN', 'F - Dicionrio de Francs');
    end;

    if s1 = 'G' then
    begin
        sintWriteLn (' 7.0 '); msgbaixo ('DCGREGO', 'G - Dicionrio de Grego com Concordncia em grego nas informaes');
    end;

    if s1 = 'H' then
    begin
        sintWriteLn (' 7.0 '); msgbaixo ('DCHEBRAI', 'H - Dicionrio de Hebraico com Concordncia em hebraico nas informaes');
    end;

    if s1 = 'I' then
    begin
        sintWriteLn (' 7.0 '); msgbaixo ('DCINGPOR', 'I - Dicionrio de Ingls - Portugus');
    end;

    if s1 = 'J' then
    begin
        sintWriteLn (' 7.0 '); msgbaixo ('DCDJBR', 'J - Dicionrio Jurdico Brasileiro');
    end;

    if s1 = 'K' then
    begin
        sintWriteLn (' 7.0 '); msgbaixo ('DCELEESP', 'K - Dicionrio de Eletrnica em espanhol');
    end;

    if s1 = 'L' then
    begin
        sintWriteLn (' 7.0 '); msgbaixo ('DCFILO', 'L - Dicionrio de Filosofia');
    end;

    if s1 = 'M' then
    begin
        sintWriteLn (' 7.0 '); msgbaixo ('DCNOM', 'M - Dicionrio de significado e origem dos nomes');
    end;

    if s1 = 'N' then
    begin
        sintWriteLn (' 7.0 '); msgbaixo ('DCINFO', 'N - Dicionrio de Informtica');
    end;

    if s1 = 'O' then
    begin
        sintWriteLn (' 7.0 '); msgbaixo ('DCOXFORD', 'O - Oxford');
    end;

    if s1 = 'P' then
    begin
        sintWriteLn (' 7.0 '); msgbaixo ('DCPOR', 'P - Dicionrio de Portugus');
    end;

    if s1 = 'Q' then
    begin
        sintWriteLn (' 7.0 '); msgbaixo ('DCFILO2', 'Q - Dicionrio de Filosofia II');
    end;

    if s1 = 'R' then
    begin
        sintWriteLn (' 7.0 '); msgbaixo ('DCPF', 'R - Portugus - Francs');
    end;

    if s1 = 'S' then
    begin
        sintWriteLn (' 7.0 '); msgbaixo ('DCINGESP', 'S - Ingls - Espanhol');
    end;

    if s1 = 'T' then
    begin
        sintWriteLn (' 7.0 '); msgbaixo ('DCITAPOR', 'T - Italiano - Portugus');
    end;

    if s1 = 'U' then
    begin
        sintWriteLn (' 7.0 '); msgbaixo ('DCPSI', 'U - Dicionrio de psicologia');
    end;

    if s1 = 'V' then
    begin
        sintWriteLn (' 7.0 '); msgbaixo ('DCALEPOR', 'V - Alemo - Portugus');
    end;

    if s1 = 'W' then
    begin
        sintWriteLn (' 7.0 '); msgbaixo ('DCWEBSTE', 'W - Webster');
    end;

    if s1 = 'X' then
    begin
        sintWriteLn (' 7.0 '); msgbaixo ('DCEPRPOR', 'X - Esperanto - Portugus');
    end;

    if s1 = 'Y' then
    begin
        sintWriteLn (' 7.0 '); msgbaixo ('DCTER', 'Y - Dicionrio de Termos usados em portugus');
    end;

    if s1 = 'Z' then
    begin
        sintWriteLn (' 7.0 '); msgbaixo ('DCQUI', 'Z - Dicionrio de Qumica');
    end;

    if s1 = '1' then
    begin
        sintWriteLn (' 7.0 '); msgbaixo ('DCPI', '1 - Portugus - Ingls');
    end;

    end;

{-----------------------------}

Procedure TrocaDicionario;
var
    arqini, s1: String;
    retorno:byte;
    sz: array [0..144] of char;

begin
  LimpaBaixo;
  gotoxy(2, 24);
write(barramenu);

(*   gotoxy(20, 11);
  write ('A - Dicionrio Jurdico de Latim');
  gotoxy(20, 12);
  write ('B - Dicionrio da Bblia de Almeida');
  gotoxy(20, 13);
  write ('C - Dicionrio de Sociologia');
  gotoxy(20, 14);
  write ('D - Espanhol - Portugus');
  gotoxy(20, 15);
  write ('E - Espanhol - Espanhol');
  gotoxy(20, 16);
  write ('F - Dicionrio de Francs');
  gotoxy(20, 17);
  write ('G - Dicionrio de Grego com Concordncia em grego nas informaes');
  gotoxy(20, 18);
  write ('H - Dicionrio de Hebraico com Concordncia em hebraico nas informaes');
  gotoxy(20, 19);
  write ('I - Dicionrio de Ingls - Portugus');
  gotoxy(20, 20);
  write ('J - Dicionrio Jurdico Brasileiro');
  gotoxy(20, 21);
  write ('K - Dicionrio de Eletrnica em espanhol');
  gotoxy(20, 22);
  write ('L - Dicionrio de Filosofia');
  gotoxy(20, 23);
  write ('M - Dicionrio de significado e origem dos nomes');
  gotoxy(20, 24);
  write ('N - Dicionrio de Informtica');
  gotoxy(20, 25);
  write ('O - Oxford');
  gotoxy(20, 26);
  write ('P - Dicionrio de Portugus');
  gotoxy(20, 27);
  write ('Q - Dicionrio de Filosofia II');
  gotoxy(20, 28);
  write ('R - Portugus - Francs');
  gotoxy(20, 29);
  write ('S - Ingls - Espanhol');
  gotoxy(20, 30);
  write ('T - Italiano - Portugus');
  gotoxy(20, 31);
  write ('U - Dicionrio de psicologia');
  gotoxy(20, 32);
  write ('V - Alemo - Portugus');
  gotoxy(20, 33);
  write ('W - Webster');
  gotoxy(20, 34);
  write ('X - Esperanto - Portugus');
  gotoxy(20, 35);
  write ('Y - Dicionrio de Termos usados em portugus');
  gotoxy(20, 36);
  write ('Z - Dicionrio de Qumica');
  gotoxy(20, 37);
  write ('1 - Portugus - Ingls');
  gotoxy(2, 8); write(consultar);
*)

  msgbaixo('DCDICDES', 'Qual o dicionrio desejado?');

            gotoxy (20, 11);
            popupMenuCria (20, 11, 50, 27, RED);

  popupMenuAdiciona ('DCLATIM', 'A - Dicionrio Jurdico de Latim');
  popupMenuAdiciona ('DCDBAL', 'B - Dicionrio da Bblia de Almeida');
  popupMenuAdiciona ('DCSOCI', 'C - Dicionrio de Sociologia');
  popupMenuAdiciona ('DCESPPOR', 'D - Espanhol - Portugus');
  popupMenuAdiciona ('DCESPA', 'E - Espanhol - Espanhol');
  popupMenuAdiciona ('DCFRAN', 'F - Dicionrio de Francs');
  popupMenuAdiciona ('DCGREGO', 'G - Dicionrio de Grego com Concordncia em grego nas informaes');
  popupMenuAdiciona ('DCHEBRAI', 'H - Dicionrio de Hebraico com Concordncia em hebraico nas informaes');
  popupMenuAdiciona ('DCINGPOR', 'I - Dicionrio de Ingls - Portugus');
  popupMenuAdiciona ('DCDJBR', 'J - Dicionrio Jurdico Brasileiro');
  popupMenuAdiciona ('DCELEESP', 'K - Dicionrio de Eletrnica em espanhol');
  popupMenuAdiciona ('DCFILO', 'L - Dicionrio de Filosofia');
  popupMenuAdiciona ('DCNOM', 'M - Dicionrio de significado e origem dos nomes');
  popupMenuAdiciona ('DCINFO', 'N - Dicionrio de Informtica');
  popupMenuAdiciona ('DCOXFORD', 'O - Oxford');
  popupMenuAdiciona ('DCPOR', 'P - Dicionrio de Portugus');
  popupMenuAdiciona ('DCFILO2', 'Q - Dicionrio de Filosofia II');
  popupMenuAdiciona ('DCPF', 'R - Portugus - Francs');
  popupMenuAdiciona ('DCINGESP', 'S - Ingls - Espanhol');
  popupMenuAdiciona ('DCITAPOR', 'T - Italiano - Portugus');
  popupMenuAdiciona ('DCPSI', 'U - Dicionrio de psicologia');
  popupMenuAdiciona ('DCALEPOR', 'V - Alemo - Portugus');
  popupMenuAdiciona ('DCWEBSTE', 'W - Webster');
  popupMenuAdiciona ('DCEPRPOR', 'X - Esperanto - Portugus');
  popupMenuAdiciona ('DCTER', 'Y - Dicionrio de Termos usados em portugus');
  popupMenuAdiciona ('DCQUI', 'Z - Dicionrio de Qumica');
  popupMenuAdiciona ('DCPI', '1 - Portugus - Ingls');

retorno := popupMenuSeleciona;

case retorno of
1: arqini := 'LAT';
2: arqini := 'DBA';
3: arqini := 'SO';
4: arqini := 'EP';
5: arqini := 'ESP';
6: arqini := 'FRA';
7: arqini := 'GRE';
8: arqini := 'HEB';
9: arqini := 'IP';
10: arqini := 'DJB';
11: arqini := 'EL';
12: arqini := 'FI';
13: arqini := 'NOM';
14: arqini := 'INFO';
15: arqini := 'OXF';
16: arqini := 'POR';
17: arqini := 'FI2';
18: arqini := 'PF';
19: arqini := 'IE';
20: arqini := 'ITP';
21: arqini := 'PSI';
22: arqini := 'AP';
23: arqini := 'WEB';
24: arqini := 'EPR';
25: arqini := 'TER';
26: arqini := 'QUI';
27: arqini := 'PI';
Else
msgbaixo('DCDESIST', 'Operao cancelada.');
exit;
END;

    if (arqini = 'LAT') or (arqini = '') then
    begin
    s1 := 'A';
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
    end;

    if arqini = 'DBA' then
    begin
    s1 := 'B';
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
    end;

    if arqini = 'SO' then
    begin
    s1 := 'C';
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
    end;

    if arqini = 'EP' then
    begin
    s1 := 'D';
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
    end;

    if arqini = 'ESP' then
    begin
    s1 := 'E';
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
    end;

    if arqini = 'FRA' then
    begin
    s1 := 'F';
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
    end;

    if arqini = 'GRE' then
    begin
    s1 := 'G';
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
    end;

    if arqini = 'HEB' then
    begin
    s1 := 'H';
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
    end;

    if arqini = 'IP' then
    begin
    s1 := 'I';
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
    end;

    if arqini = 'DJB' then
    begin
    s1 := 'J';
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
    end;

    if arqini = 'ELT' then
    begin
    s1 := 'K';
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
    end;

    if arqini = 'FI' then
    begin
    s1 := 'L';
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
    end;

    if arqini = 'NOM' then
    begin
    s1 := 'M';
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
    end;

    if arqini = 'INFO' then
    begin
    s1 := 'N';
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
    end;

    if arqini = 'OXF' then
    begin
    s1 := 'O';
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
    end;

    if arqini = 'POR' then
    begin
    s1 := 'P';
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
    end;

    if arqini = 'FI2' then
    begin
    s1 := 'Q';
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
    end;

    if arqini = 'PF' then
    begin
    s1 := 'R';
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
    end;

    if arqini = 'IE' then
    begin
    s1 := 'S';
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
    end;

    if arqini = 'ITP' then
    begin
    s1 := 'T';
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
    end;

    if arqini = 'PSI' then
    begin
    s1 := 'U';
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
    end;

    if arqini = 'AP' then
    begin
    s1 := 'V';
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
    end;

    if arqini = 'WEB' then
    begin
    s1 := 'W';
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
    end;

    if arqini = 'EPR' then
    begin
    s1 := 'X';
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
    end;

    if arqini = 'TER' then
    begin
    s1 := 'Y';
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
    end;

    if arqini = 'QUI' then
    begin
    s1 := 'Z';
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
    end;

    if arqini = 'PI' then
    begin
    s1 := '1';
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
    end;

    ConfiguraDicionario (arqini);
                msgbaixo('DCOK', 'OK');

if s1 = 'A' then s1 := 'A - Dicionrio Jurdico de Latim';
if s1 = 'B' then s1 := 'B - Dicionrio da Bblia de Almeida';
if s1 = 'C' then s1 := 'C - Dicionrio de Sociologia';
if s1 = 'D' then s1 := 'D - Espanhol - Portugus';
if s1 = 'E' then s1 := 'E - Espanhol - Espanhol';
if s1 = 'F' then s1 := 'F - Dicionrio de Francs';
if s1 = 'G' then s1 := 'G - Dicionrio de Grego com Concordncia em grego nas informaes';
if s1 = 'H' then s1 := 'H - Dicionrio de Hebraico com Concordncia em hebraico nas informaes';
if s1 = 'I' then s1 := 'I - Dicionrio de Ingls - Portugus';
if s1 = 'J' then s1 := 'J - Dicionrio Jurdico Brasileiro';
if s1 = 'K' then s1 := 'K - Dicionrio de Eletrnica em espanhol';
if s1 = 'L' then s1 := 'L - Dicionrio de Filosofia';
if s1 = 'M' then s1 := 'M - Dicionrio de significado e origem dos nomes';
if s1 = 'N' then s1 := 'N - Dicionrio de Informtica';
if s1 = 'O' then s1 := 'O - Oxford';
if s1 = 'P' then s1 := 'P - Dicionrio de Portugus';
if s1 = 'Q' then s1 := 'Q - Dicionrio de Filosofia II';
if s1 = 'R' then s1 := 'R - Portugus - Francs';
if s1 = 'S' then s1 := 'S - Ingls - Espanhol';
if s1 = 'T' then s1 := 'T - Italiano - Portugus';
if s1 = 'U' then s1 := 'U - Dicionrio de psicologia';
if s1 = 'V' then s1 := 'V - Alemo - Portugus';
if s1 = 'W' then s1 := 'W - Webster';
if s1 = 'X' then s1 := 'X - Esperanto - Portugus';
if s1 = 'Y' then s1 := 'Y - Dicionrio de termos usados em portugus';
if s1 = 'Z' then s1 := 'Z - Dicionrio de Qumica';
if s1 = '1' then s1 := '1 - Portugus - Ingls';

    clrscr;
    strPCopy (tituloJan, 'DICVOX ' + '7.0 ' + s1);
    setWindowText (crtWindow, tituloJan);
end;

{-----------------------------}

Procedure Inicializa;
var s, s1: string;
     erro, n: integer;
    sz: array [0..144] of char;
    comSapi: boolean;
     velGeral, confTipoSapi, confNum, confVeloc, confTonal: integer;
begin
    s := sintAmbiente ('DICVOX', 'VELOCIDADE');
    if s = '' then
        n := 0
    else
        val (s, n, erro);
   sintInic (n, sintAmbiente ('DICVOX', 'DIRDICVOX'));

  EscreveTela;
  sintteclacorta(true);
{  SintSom ('DCMSG2');}
  msgbaixo('DCAGUARD', 'Aguarde');
    s := sintAmbiente ('DICVOX', 'FALARPONTUACAO');
    if s = '' then
    begin
    sintFalaPont := copy (sintAmbiente ('DICVOX', 'FALARPONTUACAO'), 1, 1) = 'N';
    end
    else
    sintFalaPont := copy (sintAmbiente ('DICVOX', 'FALARPONTUACAO'), 1, 1) <> 'N';
        if sintFalaPont then
begin
  sintFalaPont :=true;
end;

    s := sintAmbiente ('DICVOX', 'GRAVAPROCURA');
    if s = '' then
    begin
    gravaAsProcuras := copy (sintAmbiente ('DICVOX', 'GRAVAPROCURA'), 1, 1) = 'N';
    end
    else
    gravaAsProcuras := copy (sintAmbiente ('DICVOX', 'GRAVAPROCURA'), 1, 1) <> 'N';
        if gravaAsProcuras then
begin
  gravaAsProcuras :=true;
end;

    dirDados := sintAmbiente ('DICVOX', 'DADOSDIC');
    if dirDados = '' then
        begin
            dirDados := 'c:\dicvox';
            strPCopy (sz, dirDados);
            writePrivateProfileString('DICVOX', 'DADOSDIC',     sz, 'DOSVOX.INI');
        end;

  DadosMarca := dirDados + '\marcas.dat'; {' + arqini + '\marcas.dat';}
    LeMarcadores;

    comSapi := primeiraLetra (sintAmbiente('DICVOX', 'SAPIATIVADO')) = 'S';

    val (sintAmbiente('DICVOX', 'TIPOSAPI'), confTipoSapi, erro);
    if erro <> 0 then val (sintAmbiente('SERVFALA', 'TIPOSAPI'), confTipoSapi, erro);
    if erro <> 0 then confTipoSapi := 4;

    val (sintAmbiente('DICVOX', 'NUMEROSAPI'), confNum, erro);
    if erro <> 0 then val (sintAmbiente('SERVFALA', 'VOZ'), confNum, erro);
    if erro <> 0 then confNum := 1;

    s := sintAmbiente ('DICVOX', 'VELOCIDADE');
    if (s = '') or (s = '0') then
        s := sintAmbiente ('DICVOX', 'VELOCIDADE');
    if s = '' then
        velGeral := 0
    else
        val (s, velGeral, erro);
//    sintReinic (velGeral, comSapi, confTipoSapi, confNum, confVeloc, confTonal);

    val (sintAmbiente('DICVOX', 'VELOCIDADESAPI'), confVeloc, erro);
    if erro <> 0 then confVeloc:= 0;
    val (sintAmbiente('DICVOX', 'TONALIDADESAPI'), confTonal, erro);
    if erro <> 0 then confTonal:= 0;

    s := sintAmbiente ('DICVOX', 'SAPIATIVADO');
    if (s <> '') and (upcase(s[1]) = 'S') then
    sintReinic (velGeral, comSapi, confTipoSapi, confNum, confVeloc, confTonal);

    s := sintAmbiente ('DICVOX', 'GRAVAPROCURA');
    if s = '' then
    begin
            s := 'SIM';
            strPCopy (sz, s);
            writePrivateProfileString('DICVOX', 'GRAVAPROCURA',     sz, 'DOSVOX.INI');
    end;

    msgbaixo ('DCINGPOR', 'I - Dicionrio de Ingls - Portugus');
    ConfiguraDicionario('IP');

    s := sintAmbiente ('DICVOX', 'DIRGRAVA');
    if s = '' then
    begin
            s := 'C:\Winvox\treino';
            strPCopy (sz, s);
            writePrivateProfileString('DICVOX', 'DIRGRAVA',     sz, 'DOSVOX.INI');
    end;

    s1 := sintAmbiente ('DICVOX', 'DICATU');
            s1 := 'I';
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
if s1 = 'I' then s1 := 'I - Dicionrio de Ingls - Portugus';
    clrscr;
    strPCopy (tituloJan, 'DICVOX ' + '7.0 ' + s1);
    setWindowText (crtWindow, tituloJan);

    procuraVerbetesNoTexto;

    s1 := sintAmbiente ('DICVOX', 'DICATU');

    if s1 = 'A' then
    begin
    msgbaixo ('DCLATIM', 'A - Dicionrio Jurdico de Latim');
    ConfiguraDicionario('LAT');
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
if s1 = 'A' then s1 := 'A - Dicionrio Jurdico de Latim';
    clrscr;
    strPCopy (tituloJan, 'DICVOX ' + '7.0 ' + s1);
    setWindowText (crtWindow, tituloJan);
    exit;
    end
    else

    if s1 = 'B' then
    begin
    msgbaixo ('DCDBAL', 'B - Dicionrio da Bblia de Almeida');
    ConfiguraDicionario('DBA');
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
if s1 = 'B' then s1 := 'B - Dicionrio da Bblia de Almeida';
    clrscr;
    strPCopy (tituloJan, 'DICVOX ' + '7.0 ' + s1);
    setWindowText (crtWindow, tituloJan);
    exit;
    end
    else

    if s1 = 'C' then
    begin
    msgbaixo ('DCSOCI', 'C - Dicionrio de Sociologia');
    ConfiguraDicionario('SO');
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
if s1 = 'C' then s1 := 'C - Dicionrio de Sociologia';
    clrscr;
    strPCopy (tituloJan, 'DICVOX ' + '7.0 ' + s1);
    setWindowText (crtWindow, tituloJan);
    exit;
    end
    else

    if s1 = 'D' then
    begin
    msgbaixo ('DCESPPOR', 'D - Espanhol - Portugus');
    ConfiguraDicionario('EP');
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
if s1 = 'D' then s1 := 'D - Espanhol - Portugus';
    clrscr;
    strPCopy (tituloJan, 'DICVOX ' + '7.0 ' + s1);
    setWindowText (crtWindow, tituloJan);
    exit;
    end
    else

    if s1 = 'E' then
    begin
    msgbaixo ('DCESPA', 'E - Espanhol - Espanhol');
    ConfiguraDicionario('ESP');
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
if s1 = 'E' then s1 := 'E - Espanhol - Espanhol';
    clrscr;
    strPCopy (tituloJan, 'DICVOX ' + '7.0 ' + s1);
    setWindowText (crtWindow, tituloJan);
    exit;
    end
    else

    if s1 = 'F' then
    begin
    msgbaixo ('DCFRAN', 'F - Dicionrio de Francs');
    ConfiguraDicionario('FRA');
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
if s1 = 'F' then s1 := 'F - Dicionrio de Francs';
    clrscr;
    strPCopy (tituloJan, 'DICVOX ' + '7.0 ' + s1);
    setWindowText (crtWindow, tituloJan);
    exit;
    end
    else

    if s1 = 'G' then
    begin
    msgbaixo ('DCGREGO', 'G - Dicionrio de Grego com Concordncia em grego nas informaes');
    ConfiguraDicionario('GRE');
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
if s1 = 'G' then s1 := 'G - Dicionrio de Grego com Concordncia em grego nas informaes';
    clrscr;
    strPCopy (tituloJan, 'DICVOX ' + '7.0 ' + s1);
    setWindowText (crtWindow, tituloJan);
    exit;
    end
    else

    if s1 = 'H' then
    begin
    msgbaixo ('DCHEBRAI', 'H - Dicionrio de Hebraico com Concordncia em hebraico nas informaes');
    ConfiguraDicionario('HEB');
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
if s1 = 'H' then s1 := 'H - Dicionrio de Hebraico com Concordncia em hebraico nas informaes';
    clrscr;
    strPCopy (tituloJan, 'DICVOX ' + '7.0 ' + s1);
    setWindowText (crtWindow, tituloJan);
    exit;
    end
    else

    if s1 = 'I' then
    begin
    msgbaixo ('DCINGPOR', 'I - Dicionrio de Ingls - Portugus');
    ConfiguraDicionario('IP');
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
if s1 = 'I' then s1 := 'I - Dicionrio de Ingls - Portugus';
    clrscr;
    strPCopy (tituloJan, 'DICVOX ' + '7.0 ' + s1);
    setWindowText (crtWindow, tituloJan);
    exit;
    end
    else

    if s1 = 'J' then
    begin
    msgbaixo ('DCDJBR', 'J - Dicionrio Jurdico Brasileiro');
    ConfiguraDicionario('DJB');
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
if s1 = 'J' then s1 := 'J - Dicionrio Jurdico Brasileiro';
    clrscr;
    strPCopy (tituloJan, 'DICVOX ' + '7.0 ' + s1);
    setWindowText (crtWindow, tituloJan);
    exit;
    end
    else

    if s1 = 'K' then
    begin
    msgbaixo ('DCELEESP', 'K - Dicionrio de Eletrnica em espanhol');
    ConfiguraDicionario('EL');
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
if s1 = 'K' then s1 := 'K - Dicionrio de Eletrnica em espanhol';
    clrscr;
    strPCopy (tituloJan, 'DICVOX ' + '7.0 ' + s1);
    setWindowText (crtWindow, tituloJan);
    exit;
    end
    else

    if s1 = 'L' then
    begin
    msgbaixo ('DCFILO', 'L - Dicionrio de Filosofia');
    ConfiguraDicionario('FI');
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
if s1 = 'L' then s1 := 'L - Dicionrio de Filosofia';
    clrscr;
    strPCopy (tituloJan, 'DICVOX ' + '7.0 ' + s1);
    setWindowText (crtWindow, tituloJan);
    exit;
    end
    else

    if s1 = 'M' then
    begin
    msgbaixo ('DCNOM', 'M - Dicionrio de significado e origem dos nomes');
    ConfiguraDicionario('NOM');
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
if s1 = 'M' then s1 := 'M - Dicionrio de significado e origem dos nomes';
    clrscr;
    strPCopy (tituloJan, 'DICVOX ' + '7.0 ' + s1);
    setWindowText (crtWindow, tituloJan);
    exit;
    end
    else

    if s1 = 'N' then
    begin
    msgbaixo ('DCINFO', 'N - Dicionrio de Informtica');
    ConfiguraDicionario('INFO');
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
if s1 = 'N' then s1 := 'N - Dicionrio de Informtica';
    clrscr;
    strPCopy (tituloJan, 'DICVOX ' + '7.0 ' + s1);
    setWindowText (crtWindow, tituloJan);
    exit;
    end
    else

    if s1 = 'O' then
    begin
    msgbaixo ('DCOXFORD', 'O - Oxford');
    ConfiguraDicionario('OXF');
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
if s1 = 'O' then s1 := 'O - Oxford';
    clrscr;
    strPCopy (tituloJan, 'DICVOX ' + '7.0 ' + s1);
    setWindowText (crtWindow, tituloJan);
    exit;
    end
    else

    if s1 = 'P' then
    begin
    msgbaixo ('DCPOR', 'P - Dicionrio de Portugus');
    ConfiguraDicionario('POR');
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
if s1 = 'P' then s1 := 'P - Dicionrio de Portugus';
    clrscr;
    strPCopy (tituloJan, 'DICVOX ' + '7.0 ' + s1);
    setWindowText (crtWindow, tituloJan);
    exit;
    end
    else

    if s1 = 'Q' then
    begin
    msgbaixo ('DCFILO2', 'Q - Dicionrio de Filosofia II');
    ConfiguraDicionario('FI2');
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
if s1 = 'Q' then s1 := 'Q - Dicionrio de Filosofia II';
    clrscr;
    strPCopy (tituloJan, 'DICVOX ' + '7.0 ' + s1);
    setWindowText (crtWindow, tituloJan);
    exit;
    end
    else

    if s1 = 'R' then
    begin
    msgbaixo ('DCPF', 'R - Portugus - Francs');
    ConfiguraDicionario('PF');
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
if s1 = 'R' then s1 := 'R - Portugus - Francs';
    clrscr;
    strPCopy (tituloJan, 'DICVOX ' + '7.0 ' + s1);
    setWindowText (crtWindow, tituloJan);
    exit;
    end
    else

    if s1 = 'S' then
    begin
    msgbaixo ('DCINGESP', 'S - Ingls - Espanhol');
    ConfiguraDicionario('IE');
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
if s1 = 'S' then s1 := 'S - Ingls - Espanhol';
    clrscr;
    strPCopy (tituloJan, 'DICVOX ' + '7.0 ' + s1);
    setWindowText (crtWindow, tituloJan);
    exit;
    end
    else

    if s1 = 'T' then
    begin
    msgbaixo ('DCITAPOR', 'T - Italiano - Portugus');
    ConfiguraDicionario('ITP');
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
if s1 = 'T' then s1 := 'T - Italiano - Portugus';
    clrscr;
    strPCopy (tituloJan, 'DICVOX ' + '7.0 ' + s1);
    setWindowText (crtWindow, tituloJan);
    exit;
    end
    else

    if s1 = 'U' then
    begin
    msgbaixo ('DCPSI', 'U - Dicionrio de psicologia');
    ConfiguraDicionario('PSI');
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
if s1 = 'U' then s1 := 'U - Dicionrio de psicologia';
    clrscr;
    strPCopy (tituloJan, 'DICVOX ' + '7.0 ' + s1);
    setWindowText (crtWindow, tituloJan);
    exit;
    end
    else

    if s1 = 'V' then
    begin
    msgbaixo ('DCALEPOR', 'V - Alemo - Portugus');
    ConfiguraDicionario('AP');
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
if s1 = 'V' then s1 := 'V - Alemo - Portugus';
    clrscr;
    strPCopy (tituloJan, 'DICVOX ' + '7.0 ' + s1);
    setWindowText (crtWindow, tituloJan);
    exit;
    end
    else

    if s1 = 'W' then
    begin
    msgbaixo ('DCWEBSTE', 'W - Webster');
    ConfiguraDicionario('WEB');
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
if s1 = 'W' then s1 := 'W - Webster';
    clrscr;
    strPCopy (tituloJan, 'DICVOX ' + '7.0 ' + s1);
    setWindowText (crtWindow, tituloJan);
    exit;
    end
    else

    if s1 = 'X' then
    begin
    msgbaixo ('DCEPRPOR', 'X - Esperanto - Portugus');
    ConfiguraDicionario('EPR');
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
if s1 = 'X' then s1 := 'X - Esperanto - Portugus';
    clrscr;
    strPCopy (tituloJan, 'DICVOX ' + '7.0 ' + s1);
    setWindowText (crtWindow, tituloJan);
    exit;
    end
    else

    if s1 = 'Y' then
    begin
    msgbaixo ('DCTER', 'Y - Dicionrio de Termos usados em portugus');
    ConfiguraDicionario('TER');
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
if s1 = 'Y' then s1 := 'Y - Dicionrio de termos usados em portugus';
    clrscr;
    strPCopy (tituloJan, 'DICVOX ' + '7.0 ' + s1);
    setWindowText (crtWindow, tituloJan);
    exit;
    end
    else

    if s1 = 'Z' then
    begin
    msgbaixo ('DCQUI', 'Z - Dicionrio de Qumica');
    ConfiguraDicionario('QUI');
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
if s1 = 'Z' then s1 := 'Z - Dicionrio de Qumica';
    clrscr;
    strPCopy (tituloJan, 'DICVOX ' + '7.0 ' + s1);
    setWindowText (crtWindow, tituloJan);
    exit;
    end
    else

    if s1 = '1' then
    begin
    msgbaixo ('DCPI', '1 - Portugus - Ingls');
    ConfiguraDicionario('PI');
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
if s1 = '1' then s1 := '1 - Portugus - Ingls';
    clrscr;
    strPCopy (tituloJan, 'DICVOX ' + '7.0 ' + s1);
    setWindowText (crtWindow, tituloJan);
    exit;
    end
    else

    if s1 = '' then
    begin
    msgbaixo ('DCINGPOR', 'I - Dicionrio de Ingls - Portugus');
    ConfiguraDicionario('IP');
            strPCopy (sz, s1);
            writePrivateProfileString('DICVOX', 'DICATU',     sz, 'DOSVOX.INI');
if s1 = '' then s1 := 'A - Dicionrio Jurdico de Latim';
    clrscr;
    strPCopy (tituloJan, 'DICVOX ' + '7.0 ' + s1);
    setWindowText (crtWindow, tituloJan);
    exit;
    end;

end;

Procedure apresenta;
begin
  gotoxy(33, 8);  write('Apresentao:');
  gotoxy(15,11);  write('Programa de consulta a Dicionrios');
  gotoxy(12,14);  write(
  'Para adquirir o produto faa download do endereo');
  gotoxy(12,15);  write(
  'http://intervox.nce.ufrj.br/~glaucofc/dicvox.zip');
  gotoxy(12,17);  write(
  'ou atravs do e-mail: <glaucofc@intervox.nce.ufrj.br>');
{  gotoxy(21,24);  write('Tecle ENTER para continuar');}
{  sintsom('DCTECENT');}
{  repeat until readkey = #13;}
{sintclek;}
 end;

Function Finaliza:Char;
begin
  LimpaBaixo;
  gotoxy(2,24);
  write('                Que as palavras aqui lidas iluminem sua vida !               ');
  gotoxy(33, 8); write('Finalizao:');
  gotoxy(20, 11); write('Obrigado por utilizar nossos programas');
  textbackground(red); textcolor(white); highvideo;
  gotoxy(2,13); write(
'            Este produto no deve ser copiado de nenhuma forma!             ');
  gotoxy(2, 14); write(
'         Qualquer cpia ilegal sofrer as medidas cabveis da Lei.          ');
  normvideo; textbackground(blue); textcolor(lightgray);
  gotoxy(5,16); write(
'Caso voc desejar maiores informaes sobre o Dicvox, fale conosco.');
  gotoxy(12,17); write(
'Jesus Cristo  o nico caminho para nossa Salvao.');
  gotoxy(15,18); write(
'Atenda ao seu chamado antes que seja tarde !');
  gotoxy(5,19); write(
'Lembre-se: A palavra de Deus  alimento para nossas almas.');
  gotoxy(18, 21); write(
'Que Jesus te abenoe e te guarde.');

  GravaMarcadores;
  close(quelinha);
  finaliza := #255;
  sintteclacorta (true);
//  msgbaixo('DCFIMDIC', 'Fim do Dicvox');
delay (3);
  sintFim;
  doneWinCrt;
end;

Procedure PegaOpcao;
var c: char;
begin
  sintteclacorta(true);
repeat
  LimpaBaixo;
  gotoxy(2, 24); write(barramenu);
  gotoxy(20, 11);
  write('L - Leitura corrente do Dicionrio');
  gotoxy(20, 13);
  write ('P - Procurar por passagem');
  gotoxy(20,15);
  write ('T - Procurar por texto');
  gotoxy(20, 17);
  write ('M - Localizar marcadores de livro');
  gotoxy(20, 19);
  write ('I - Informaes sobre o Dicionrio');
  gotoxy(20, 20);
  write ('V - Seleciona dicionrio');
 gotoxy(20, 21);
  write('F - Finalizar programa');
  gotoxy(2, 8); write(consultar);
  repeat
  sintsom ('DCTPCONS');
    opc :=upcase( readKey);
//    If opc =#0  then lixo :=readkey;
    If (opc in [F2..F3, F5..f12]) then opc :=#0;
    If opc =F1  then     Ajuda1;
    If opc =F4  then     formConfig;
    If opc =F8  then     FalaHora;
//    If opc =CTLF8  then     FalaDia; {Tecla em conflito com a letra 'e' que muda velocidade}

    If opc =F7  then      begin
c := '5';
        begin
            sintFim;
            sintInic (ord(c) - ord('0'), sintambiente ('DICVOX', 'DIRDICVOX'));
end;
end;
    If opc =CTLF3  then       begin
c := '4';
        begin
            sintFim;
            sintInic (ord(c) - ord('0'), sintambiente ('DICVOX', 'DIRDICVOX'));
end;
end;
    If opc =CTLF2  then        begin
c := '3';
        begin
            sintFim;
            sintInic (ord(c) - ord('0'), sintambiente ('DICVOX', 'DIRDICVOX'));
end;
end;
    If opc =CTLF1  then        begin
c := '2';
        begin
            sintFim;
            sintInic (ord(c) - ord('0'), sintambiente ('DICVOX', 'DIRDICVOX'));
end;
end;

  Until opc in [' ', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', 'A', 'P','I','F','M','L', 'V', ^V, 'T', ^T, ESC, ENTER,
'E', 'Q', 'R', 'W', 'H', '?',
'U', 'u', ^U, ^X];
    Case opc of
      '1': begin TrocaDicionario;
        Letudo1; end;

      '2': begin TrocaDicionario;
        Letudo2; end;

      '3': begin TrocaDicionario;
        Letudo3; end;

      '4': begin TrocaDicionario;
        Letudo4; end;

      '5': begin TrocaDicionario;
        Letudo5; end;

      '6': begin TrocaDicionario;
        Letudo6; end;

      '7': begin TrocaDicionario;
        Letudo7; end;

      '8': begin TrocaDicionario;
        Letudo8; end;

      '9': begin TrocaDicionario;
        Letudo9; end;

      '0': begin TrocaDicionario;
        Letudo0; end;


      'L', ' ', #13: Letudo;
      'V': TrocaDicionario;

      ^V: FalaVersao;

      'P': ProcuraVerbetes;
      'T': ProcuraTexto;
      'U': ProcuraTexto;
      'I': Informacoes;
      'M': Begin
        assign(arquivo, dadosdisco);
        {$i-}reset(arquivo);{$i+}
        If IOresult <> 0  Then
            msgbaixo('DCERRODT','Erro grave nos dados do sistema !')
        Else begin
               pontaux :=0;
               ponteiro :=0;
               py :=1; px :=1;
               vaiparamarca;
               If ponteiro > 0  Then
               begin
                  letrecho;
                  processaleitura;
               end;
             end;
        end;

'Q': FalaDia;

                    ^X: begin
delay (3);
    SintFim;
    doneWinCrt;
end;

      'F', ESC: opc :=Finaliza;
      'A', 'H', '?': Ajuda1;
      Else begin
              msgbaixo( 'DCOPCINV','Opo errada');
              gotoxy(2,24); write(barramenu);
           end;
    end;
  Until opc = #255;
end;

begin
  Inicializa;
  apresenta;
  {  verificacopia;}
  pegaopcao;
end.
