{--------------------------------------------------------}
{
{     Rotinas de fala do DOSVOX para Windows
{
{     Autor: Jos Antonio Borges
{
{     Em Janeiro/98
{
{--------------------------------------------------------}

unit dvwin;
interface

uses Windows, SysUtils, messages, shellApi,
     dvcrt, dvwav,
     dvtradut, dvinter, dvlenum, dvhora, dvsapi4, mmsystem, activex;

function sintAmbiente (nomeSecao, nomeAmbiente: string): string;
procedure sintInic (veloc: integer; dirSons: string);
procedure sintReinic (veloc: integer; usaSapi: boolean;
                      vozSapi, velSapi, tomSapi: integer);
procedure sintFim;
procedure sintParam (quanto, minimo, interv: integer; corta, acelera: boolean);
procedure sintTeclaCorta (teclaCorta: boolean);
procedure sintVeloc (n: integer);

function  sintFalando: boolean;
procedure sintMem (p: pchar);
procedure sintCarac (c: char);
procedure sintSom (nomeSom: string);
procedure sintPara;

procedure geraCabWav (pvet: pchar; tamSom: longint; veloc, bits, canais: integer);
procedure sintClek;
procedure sintBip;
procedure sintSoletra (s: string);
procedure sintetiza (s: string);

function sintEditaCampo (var campo: string; x, y, tamanho, tamVisual: integer;
                     altera: boolean): char;
function  sintEdita (var campo: string; x, y, tamanho: integer;
                         altera: boolean): char;
procedure sintReadLn (var s: string);
function  sintReadKey: char;
procedure sintReadint (var n: integer);
procedure sintLeTecla (var c1, c2: char);

procedure sintWrite (s: string);
procedure sintWriteLn (s: string);
procedure sintWriteint (n: longint);
procedure sintTelefona (s: string);

function existeArqSom (nomeSom: string): boolean;

function maiuscAnsi (s: string): string;
procedure limpaBufTec;
function compactaLinha (s: string): string;
procedure executaArquivo (nomeArq: string);

const
    TAMCABWAV = 44;

var
    sintFalaPont: boolean;
    sintCursorX: integer;
    sapiPresente: boolean;
    falandoSapi: boolean;
    velocAtual: integer;
    sintApagaAuto: boolean;

    sintAcumulaFala: boolean;
    sintFalaAcumulada: string;

    pausaPonto: integer;
    pausaVirg: integer;
    pausaDoisPontos: integer;

const
    ALTF1   = #104;

    CTLF1 = #94;
    CTLF2 = #95;
    CTLF3 = #96;
    CTLF4 = #97;
    CTLF5 = #98;
    CTLF6 = #99;
    CTLF7 = #100;
    CTLF8 = #101;
    CTLF9 = #102;
    CTLF10 = #103;
    CTLF11 = #104;
    CTLF12 = #105;

    F1    = #59;
    F2    = #60;
    F3    = #61;
    F4    = #62;
    F5    = #63;
    F6    = #64;
    F7    = #65;
    F8    = #66;
    F9    = #67;
    F10   = #68;
    F11   = #69;
    F12   = #70;

    INS   = #82;
    DEL   = #83;
    HOME  = #71;
    TEND  = #79;
    PGUP  = #73;
    PGDN  = #81;
    CIMA  = #72;
    BAIX  = #80;
    ESQ   = #75;
    DIR   = #77;
    ENTER = #13;
    BS    = #08;
    ESC   = #27;
    TAB   = #09;

    CTLPGUP  = #132;
    CTLPGDN  = #118;
    CTLESQ   = #115;
    CTLDIR   = #116;
    CTLUP    = #113;
    CTLDOWN  = #114;
    CTLBS    = #127;
    CTLENTER = #10;

    SHIFTINS = #$FE;
    CTLINS   = #$FF;

    GOTFOCUS = #$DE;
    NOFOCUS  = #$DF;

implementation
uses videovox;

var
    fon: string;
    nomeDirSom, nomeDirLetras: string;
    falando: boolean;
    falaCancelada: boolean;

const
    TAMCLEK = 100;
var
    clek: array [-TAMCABWAV..TAMCLEK-1] of byte;

{--------------------------------------------------------}
{                seleciona a velocidade
{--------------------------------------------------------}

procedure sintParam (quanto, minimo, interv: integer; corta, acelera: boolean);
begin
    paramFala (quanto, minimo, interv);
    speedUpWaves := acelera;
    compactWaves := corta;
end;

{--------------------------------------------------------}
{                seleciona a velocidade
{--------------------------------------------------------}

procedure sintVeloc (n: integer);
var
    c, m, i, erro: integer;
    corta, acelera: boolean;
    sn: string[2];
    s: string;

begin
    if sintAmbiente ('DOSVOX', 'MINIVOX') = 'SIM' then
        n := 2;
    velocAtual := n;

    str (n, sn);
    sintBDSom := sintAmbiente ('SINTETIZADOR', 'DIFONES'+sn);
    val (sintAmbiente ('SINTETIZADOR', 'CORTEFON'+sn), c, erro);
    val (sintAmbiente ('SINTETIZADOR', 'SOBRAFON'+sn), m, erro);
    if erro <> 0 then m := 0;
    val (sintAmbiente ('SINTETIZADOR', 'INTERPAL'+sn), i, erro);
    if erro <> 0 then i := 0;
    s := sintAmbiente ('SINTETIZADOR', 'CORTAFALA'+sn);
    corta := (s <> '') and (upcase(s[1]) <> 'N');
    s := sintAmbiente ('SINTETIZADOR', 'RAPIDINHO'+sn);
    acelera := (s <> '') and (upcase(s[1]) <> 'N');

    sintParam (c, m, i, corta, acelera);

    s := sintAmbiente ('SINTETIZADOR', 'PAUSAPONTO'+sn);
    val (s, pausaPonto, erro);
    if erro <> 0 then pausaPonto := 250;
    s := sintAmbiente ('SINTETIZADOR', 'PAUSAVIRG'+sn);
    val (s, pausaVirg, erro);
    if erro <> 0 then pausaVirg := 150;
    s := sintAmbiente ('SINTETIZADOR', 'PAUSADOISPONTOS'+sn);
    val (s, pausaDoisPontos, erro);
    if erro <> 0 then pausaDoisPontos := 200;
end;

{--------------------------------------------------------}
{                inicializa sistema de fala
{--------------------------------------------------------}

procedure sintInic (veloc: integer; dirSons: string);
var n: integer;
    returnString: array [0..255] of char;
    vozSapi, velocSapi, tomSapi: integer;
    s: string;
    erro: integer;
begin
    if sintAmbiente ('DOSVOX', 'MINIVOX') = 'SIM' then
        veloc := 2;
    if veloc < 1 then
         val (sintAmbiente ('TRADUTOR', 'VELOCIDADE'), veloc, n);

    if (veloc < 1) or (veloc > 5) then veloc := 2;
    sintVeloc (veloc);

    n := tradinic;
    if (n <> 0) and
       ((veloc = 2) or (veloc = 4)) then    {evita falha para usuarios antigos }
        begin
            tradFim;
            sintBDSom := 'DIFONES2';
            tradInic;
        end;

    if n <> 0 then
        begin
            writeln ('Erro de inicializao: ', n );
            writeln ('Banco de dados de voz: ', sintBDSom);
            tradfim;

            readln;
            doneWincrt;
        end;

    nomeDirSom := dirSons;
    if nomeDirSom <> '' then
        if nomeDirSom [length (nomeDirSom)] <> '\' then
            nomeDirSom := nomeDirSom + '\';

    n := GetPrivateProfileString('TRADUTOR', 'DIRLETRAS',
         'c:\dosvox\som\letras\', returnString, 255, 'DOSVOX.INI');
    nomeDirLetras := strPas (returnString);
    if nomeDirLetras [length(nomeDirLetras)] <> '\' then
        nomeDirLetras := nomeDirLetras + '\';

    sintVeloc (veloc);

    sapiPresente := false;
    s := sintAmbiente ('TRADUTOR', 'SAPI');
    if (s <> '') and (upcase(s[1]) <> 'N') then
        begin
            CoInitialize (NIL);
            s := sintAmbiente ('SERVFALA', 'VOZ');
            val (s, vozSapi, erro);
            s := sintAmbiente ('SERVFALA', 'VELOCIDADE');
            val (s, velocSapi, erro);
            s := sintAmbiente ('SERVFALA', 'TOM');
            val (s, tomSapi, erro);
            sapiPresente := sapiInic (vozSapi, velocSapi, tomSapi);
        end;
end;

{--------------------------------------------------------}
{                reinicializa sistema de fala
{--------------------------------------------------------}

procedure sintReinic (veloc: integer; usaSapi: boolean;
                      vozSapi, velSapi, tomSapi: integer);
begin
    sintPara;
    if sapiPresente then sapiFim;
    sapiPresente := false;

    sintVeloc (veloc);
    if usaSapi then
        begin
            if not sapiPresente then
                CoInitialize (NIL);
            if vozSapi = 0 then
                vozSapi := strToInt (sintAmbiente ('SERVFALA', 'VOZ'));
            sapiPresente := sapiInic (vozSapi, velSapi, tomSapi);
        end;
end;

{--------------------------------------------------------}
{                finaliza sistema de fala
{--------------------------------------------------------}

procedure sintFim;
begin
    if sintFalaAcumulada <> '' then sintetiza ('');
    while sintFalando do;
    sintPara;
    tradfim;

    if sapiPresente then
        begin
            sapiPresente := false;
            // CoUnInitialize;
        end;
end;

{--------------------------------------------------------}
{             gera cabecalho do formato WAV
{--------------------------------------------------------}

procedure geraCabWav (pvet: pchar; tamSom: longint; veloc, bits, canais: integer);
const
    cabWav: array [0..43] of byte = (
        $52, $49, $46, $46, $ff, $ff, $ff, $ff, $57, $41, $56, $45, $66, $6d, $74, $20,
        $10, $00, $00, $00, $01, $00, $01, $00, $11, $2b, $00, $00, $11, $2b, $00, $00,
        $01, $00, $08, $00, $64, $61, $74, $61, $ff, $ff, $ff, $ff);

var
    lpFormat: PPCMWAVEFORMAT;

var l: longint;
begin
    move (cabWav, pvet^, 44);

    l := tamSom;
    move (l, pvet[40], 4);
    l := l + 36;
    move (l, pvet[4], 4);

    lpFormat := @pvet[20];

    lpFormat^.wBitsPerSample := bits;
    lpFormat^.wf.nChannels := canais;
    lpFormat^.wf.nSamplesPerSec := veloc;
    lpFormat^.wf.nAvgBytesPerSec := veloc * canais * (bits div 8);
end;

{--------------------------------------------------------}
{            seleciona o diretorio de ambiente
{--------------------------------------------------------}

function sintAmbiente (nomeSecao, nomeAmbiente: string): string;
var
    returnString: array[0..255] of char;
begin
    if nomeSecao = '' then nomeSecao := 'DOSVOX';
    nomeSecao := nomeSecao + #$0;
    nomeAmbiente := nomeAmbiente + #$0;
    GetPrivateProfileString(@nomeSecao[1], @nomeAmbiente[1],
         '', returnString, 255, 'DOSVOX.INI');
    sintAmbiente := strPas(returnString);
end;

{--------------------------------------------------------}
{                     ve se falando
{--------------------------------------------------------}

function sintFalando: boolean;
begin
    if sapiPresente then
        begin
            if keypressed then
                begin
                    sintPara;
                    sintFalando := false;
                end
            else
                sintFalando := waveIsPlaying or sapiAtivo (0);
        end
    else
        sintFalando := waveIsPlaying;
end;

{--------------------------------------------------------}
{             espera o SAPI terminar de falar
{--------------------------------------------------------}

procedure esperaSapi;
begin
    if falandoSapi then
        begin
            while sintFalando do waitMessage;
            falandoSapi := false;
        end;
end;

{--------------------------------------------------------}
{           sintetiza um buffer em formato WAV
{--------------------------------------------------------}

procedure sintMem (p: pchar);
var l: integer;
begin
    esperaSapi;

    move (p[40], l, 4);
    wavePlayMem (p);
    while sintFalando do;
end;

{--------------------------------------------------------}
{                ecoa um Caractere
{--------------------------------------------------------}

procedure sintCarac (c: char);
var
    s: string;
begin
    esperaSapi;
    str (ord(c), s);
    wavePlayFile (dirletras + '_' + s + '.wav');
end;

{--------------------------------------------------------}
{           sintetiza som testando keypressed
{--------------------------------------------------------}

procedure sintSom (nomeSom: string);
begin
    esperaSapi;

    if nomeSom[1] = '_' then
        begin
            nomeSom := nomeDirLetras + nomeSom + '.wav';
            wavePlayFile (nomeSom);
        end
    else
        begin
            nomeSom := nomeDirSom + nomeSom + '.wav';
            wavePlayFile (nomeSom);
        end;
end;

{--------------------------------------------------------}
{           cancela a execucao de um som
{--------------------------------------------------------}

procedure sintPara;
begin
    waveStop;
    falaCancelada := true;
    if sapiPresente then
        if sapiAtivo (0) then sapiReset;
end;

{--------------------------------------------------------}
{           verifica se existe arquivo de som
{--------------------------------------------------------}

function existeArqSom (nomeSom: string): boolean;
begin
    nomeSom := nomeDirSom + nomeSom + '.wav';
    existeArqSom := fileExists (nomeSom);
end;

{--------------------------------------------------------}
{                    faz um clek
{--------------------------------------------------------}

procedure SintClek;
var salva: boolean;
begin
    esperaSapi;

    salva := compactWaves;
    compactWaves := false;

    geraCabWav (@clek, TAMCLEK, 11025, 8, 1);
    wavePlayMem (@clek);
    while sintFalando do;

    compactWaves := salva;
end;

{--------------------------------------------------------}
{                   toca um bip
{--------------------------------------------------------}

Procedure SintBip;
const
    TAMBIP = 512;
var i: integer;
    bip:  array [-TAMCABWAV..TAMBIP-1] of byte;
begin
    esperaSapi;

    while keypressed do readkey;
    i := 0;
    while i < TAMBIP do
        begin
            bip[i] := $80; inc (i);
            bip[i] := $70; inc (i);
            bip[i] := $60; inc (i);
            bip[i] := $50; inc (i);
            bip[i] := $40; inc (i);
            bip[i] := $50; inc (i);
            bip[i] := $60; inc (i);
            bip[i] := $70; inc (i);
        end;

    bip[TAMBIP-1] := $80;

    geraCabWav (@bip, TAMBIP, 11025, 8, 1);
    wavePlayMem (@bip);
    while sintFalando do;
end;

{--------------------------------------------------------}
{                soletra uma cadeia
{--------------------------------------------------------}

procedure sintSoletra (s: string);
var i: integer;
begin
    if keypressed then exit;
    for i := 1 to length (s) do
        sintCarac (s[i]);
end;

{--------------------------------------------------------}
{         le uma tecla falando, sem ecoar na tela
{--------------------------------------------------------}

function sintReadKey: char;
var c: char;
begin
    if sintFalaAcumulada <> '' then
        sintetiza ('');
    c := readkey;
    sintPara;
    sintCarac (c);
    sintReadKey := c;
end;

{--------------------------------------------------------}
{               escreve e fala uma cadeia
{--------------------------------------------------------}

procedure sintWrite (s: string);
begin
    write (s);
    sintetiza (s);
end;

{--------------------------------------------------------}
{        escreve e fala uma cadeia pulando linha
{--------------------------------------------------------}

procedure sintWriteLn (s: string);
begin
    sintWrite (s);
    writeln;
    if sintFalaAcumulada <> '' then sintetiza ('');
end;

{--------------------------------------------------------}
{        escreve e fala um numero pulando linha
{--------------------------------------------------------}

procedure sintWriteint (n: longint);
var s: string;
begin
    str (n, s);
    sintWrite (s);
end;

{--------------------------------------------------------}
{              trata os sinais de pontuacao
{--------------------------------------------------------}

procedure trataPontuacao (s: string);

    procedure espera (n: integer);
    var i: integer;
    begin
        for i := 1 to n div 50 do
            if not keypressed then delay (50);
    end;

begin
    if keypressed then exit;

    while sintFalando do;

    if sintFalaPont then sintcarac (s[1]);

    case s[1] of
        '.':   if (length (s) > 1) and (s[2] = ' ') then
                   espera (PausaPonto)
               else
                   if not sintFalaPont then sintCarac (s[1]);   { evita repetir letra }

        ',', '-':   if (length (s) > 1) and (s[2] = ' ') then
                   espera (pausaVirg)
               else
                   if not sintFalaPont then sintCarac (s[1]);   { evita repetir letra }

        ';', ':', '(', ')':   espera (pausaDoisPontos);
    end;
end;

{--------------------------------------------------------}
{                   sintetiza uma cadeia
{--------------------------------------------------------}

procedure sintetiza (s: string);
var
    encontrouHifen: boolean;
    subcad: string;
    erro: integer;
    x: longint;
    c: char;

    ultLetra: char;
    nrepUlt: integer;

const
    alfa: set of char = [' ', 'A'..'Z', 'a'..'z', #128..#255];
    alfapuro: set of char = ['A'..'Z', 'a'..'z', #128..#255];

label fim;

begin
    if sintAcumulaFala then
        begin
            if s <> '' then
                begin
                    sintFalaAcumulada := sintFalaAcumulada + ' ' + s;
                    exit;
                end
            else
                begin
                    s := sintFalaAcumulada;
                    sintFalaAcumulada := '';
                end;
        end;

    if sapiPresente then
        begin
            while sintFalando do;
            if not keypressed then
                begin
                    sapiFala (s);
                    falandoSapi := true;
                end;
            exit;
        end;

    ultLetra := ' ';
    nrepUlt := 0;

    s := s + ' ';
    falaCancelada := false;
    while not (falaCancelada) and (s <> '') do
        begin
            if keypressed then
                begin
                    sintPara;
                    goto fim;
                end;

            while s[1] = '0' do
                begin
                    sintSom ('_zero');
                    delete (s, 1, 1);
                end;

            if (s <> '') and (s[1] in ['1'..'9']) then
                begin
                    encontrouHifen := false;
                    subcad := '';
                    while (s <> '') and (s[1] in ['0'..'9', '-']) do
                        begin
                            subcad := subcad + s[1];
                            if s[1] = '-' then
                                encontrouHifen := true;
                            delete (s, 1, 1);
                        end;
                    if encontrouHifen then  { provavel numero de telefone }
                        sintSoletra (subcad)
                    else
                        begin
                            {if length (subcad) >= 7 then
                                sintSoletra (subcad)
                            else}
                                begin
                                    val (subcad, x, erro);
                                    falaNumeroConv (numeroParaString (x), MASCULINO);
                                end;
                        end;
                end
            else

            if (s <> '') and (s[1] in alfa) then
                begin
                    subcad := '';
                    while (s <> '') and (s[1] in Alfa) do
                        begin
                            subcad := subcad + s[1];
                            delete (s, 1, 1);
                        end;

                    if subcad <> '' then
                         begin
                             if maiuscAnsi (subcad) = 'WWW' then
                                 sintSoletra (subcad)
                             else
                                 begin
                                     compilaFonemas (copy (subcad, 1, 999), fon);
                                     falaFonemas (fon, false);
                                 end;
                         end;

                    if (s <> '') and (s[1] = '-') and (s[2] in alfapuro) then
                        delete (s, 1, 1);
                end
            else

                begin
                    c := ' ';
                    if s <> '' then c := s[1];

                    if ultLetra = c then
                        begin
                            nrepUlt := nrepUlt + 1;
                            if nrepUlt > 3 then
                                begin
                                    sintClek;
                                    c := ' ';
                                end;
                        end
                    else
                        begin
                            nrepUlt := 0;
                            ultLetra := c;
                        end;

                    if copy (s, 1, 1) = '-' then
                        begin
                            if length (s) > 2 then c := s[2] else c := ' ';
                            if (c = ' ') or (c = '-') then
                                trataPontuacao (s)
                            else
                            if c in ['0'..'9'] then
//                                sintSom ('_MENOS')
                            else
                                sintCarac ('-');
                        end
                    else
                    if copy (s, 1, 3) = '://' then
                        sintSoletra (s[1])
                    else
                    if c in ['.', ',', ';', ':', '(', ')'] then
                        trataPontuacao (s)
                    else
                    if (c <> ' ') and (c <> #$09) and (not keypressed) then
                        sintCarac (c);

                    delete (s, 1, 1);
                end;
        end;

fim:
end;

{--------------------------------------------------------}
{             calcula uma string em maiuscula
{--------------------------------------------------------}

function maiuscAnsi (s: string): string;
var x: string;
    i: integer;
begin
    x := s;
    for i:= 1 to length (s) do
        if x[i] in ['a'..'z'] then
            x[i] := upcase (x[i])
        else
            if x[i] in [#$e0..#$ff] then
                x[i] := chr (ord(x[i]) - $20);
    maiuscAnsi := x;
end;

{--------------------------------------------------------}
{                limpa o buffer do teclado
{--------------------------------------------------------}

procedure limpaBufTec;
begin
    while keypressed do readkey;
end;

{--------------------------------------------------------}
{                 le uma tecla, ecoando
{--------------------------------------------------------}

procedure sintLeTecla (var c1, c2: char);
label inicio;
begin
inicio:
    while sintFalando do;     { permite fechamento do dispositivo de som }
    c2 := ' ';
    c1 := readkey;
    if c1 = #0 then c2 := readkey;

    if (c1 = #0) and (c2 = F8) then
        begin
            falaHora;
            goto inicio;
        end;

    if (c1 <> GOTFOCUS) and (c1 <> NOFOCUS) then
        if c1 in [#32..#126, #127..#255] then
            begin
                sintCarac (c1);
                write (c1);
            end;
end;

{--------------------------------------------------------}
{                produz sinais dtmf
{--------------------------------------------------------}

procedure sintTelefona (s: string);
var i: integer;
    c: char;
    salva: boolean;
begin
    salva := speedUpWaves;
    speedUpWaves := false;
    for i := 1 to length (s) do
        begin
            c := upcase (s[i]);
            if c in ['0'..'9', {'A'..'D',} '#', '*'] then
                begin
                    if c = '*' then c := 'X';
                    wavePlayFile (dirletras + 'dtmf_' + c + '.wav');
                    while sintFalando do;
                    delay (100);
                end
            else
                if c = ',' then
                    delay (1000);
        end;
    speedUpWaves := salva;
end;

{--------------------------------------------------------}
{     tira brancos do inicio e do fim de uma cadeia
{--------------------------------------------------------}

function compactaLinha (s: string): string;
begin
    while (s <> '') and (s[1] = ' ') do
        delete (s, 1, 1);
    while (s <> '') and (s[length(s)] = ' ') do
        delete (s, length(s), 1);
    compactaLinha := s;
end;

{--------------------------------------------------------}
{                       executa um arquivo
{--------------------------------------------------------}

procedure executaArquivo (nomeArq: string);
var extensao: string[3];
    nomeProg, nomeDir: string;
    p: integer;
label exec;
begin
    getdir (0, nomeDir);

    if (copy (nomeArq, 1,  7) = 'http://') or
       (copy (nomeArq, 1, 4) = 'www.') then
        begin
            nomeProg := sintAmbiente ('DOSVOX', 'PROG.HTM');
            goto exec;
        end;

    p := pos ('.', nomeArq);
    extensao := maiuscAnsi (copy (nomeArq, p+1, 3));
    if (extensao = 'EXE') or (extensao = 'COM') then
        begin
            if nomeDir [length (nomeDir)] = '\' then
                nomeProg := nomedir + nomeArq
            else
//                nomeProg := nomedir + '\' + nomeArq;
                nomeProg := nomeArq;
            nomeArq := '';
        end
    else
        begin
            nomeProg := sintAmbiente ('DOSVOX', 'PROG.' + extensao);
            if nomeProg = '' then
                begin
                    nomeProg := nomeArq;
                    nomeArq := '';
                end;
    end;

exec:
    while sintFalando do;
    ShellExecute (crtWindow, 'open', @nomeProg[1], @nomeArq[1], @nomeDir[1], SW_SHOWNORMAL);
    while sintFalando do;
end;

{--------------------------------------------------------}
{                    edita um item
{--------------------------------------------------------}

function sintEditaCampo (var campo: string; x, y, tamanho, tamVisual: integer;
                     altera: boolean): char;
var c, c2: char;
    curx, i: integer;
    primeiraVez: boolean;
    colInic: integer;

label fechaCampo;

{--------------------------------------------------------}

    procedure caracComum (c: char);
    begin
        if not altera then
            exit;

        if curx > tamanho then
            begin
                sintBip;
                exit;
            end;

        insert (c, campo, curx);
        delete (campo, tamanho+1, 1);

        gotoxy (x+curx-1, y);
        write (c);

        if falando then
            sintCarac (c);
        curx := curx + 1;
    end;

{--------------------------------------------------------}

    procedure delCarac (comDel: boolean);
    var campoPc: string;
        c: char;
    begin
        if not altera then
            exit;

        c := campo [curx];
        delete (campo, curx, 1);
        campo := campo + ' ';

        gotoxy (x, y);
        campoPC := copy (campo, colinic, tamVisual);
        write (campoPC);

        if comDel then sintSom ('_DEL');
        sintCarac(c);
    end;

{--------------------------------------------------------}

    function temVogal (s: string): boolean;
    const
        CONSOANTES: set of char =
        ['B','C','D','F','G','H','J','K','L','M',
         'N','P','Q','R','S','T','V','X','Z'];

    var i: integer;

    begin
        temVogal := true;
        for i := 1 to length (s) do
             if not (upcase (s[i]) in CONSOANTES) then exit;
        temVogal := false;
    end;

{--------------------------------------------------------}

    procedure falaPalavra;
    var palavra: string;
        c: char;
        salvacur: integer;
    begin
        campo := campo + #0;
        salvacur := curx;
        while campo [curx] = ' ' do
            curx := curx + 1;

        c := upcase (campo [curx]);
        case c of
            #0: sintBip;

            'A'..'Z', #128..#255:
                begin
                    palavra := '';
                    repeat
                        palavra := palavra + campo[curx];
                        curx := curx + 1;
                    until not (upcase (campo[curx]) in
                            ['A'..'Z', #128..#255]);
                    if temVogal (palavra) then
                        sintetiza (palavra)
                    else
                        sintSoletra (palavra);
                end;

            '0'..'9', '-':
                begin
                    palavra := '';
                    repeat
                        palavra := palavra + campo[curx];
                        curx := curx + 1;
                    until not (campo[curx] in ['0'..'9']);
                    sintetiza (palavra);
                end;

        else
            begin
                palavra := campo [curx];
                curx := curx + 1;
                sintSoletra (palavra);
            end;
        end { case };

        campo := copy (campo, 1, length(campo)-1);
        if c = #0 then
            curx := salvacur;
    end;

{--------------------------------------------------------}

    procedure avancaPalavra;
    var tam: integer;
        c: char;
    begin
        tam := length (campo);
        campo := campo + ' @';

        c := campo [curx];
        if c <> ' ' then
            if c in ['0'..'9'] then
                repeat
                    curx := curx + 1;
                    c := campo [curx];
                until not (c in ['0'..'9'])
            else
                repeat
                    curx := curx + 1;
                    c := campo [curx];
                until not (c in ['a'..'z', 'A'..'Z', #128..#255]);

        if c = ' ' then
            repeat
                curx := curx + 1;
                c := campo [curx];
            until c <> ' ';

        campo := copy (campo, 1, tam);

        if curx > tam+1 then
            begin
                curx := length(campo)+1;
                repeat
                    curx := curx - 1;
                until (curx = 0) or (campo[curx] <> ' ');
                curx := curx + 1;
                sintBip;
            end
        else
            sintClek;
    end;

{--------------------------------------------------------}

    procedure recuaPalavra;
    var tam: integer;
        c: char;
    begin
        tam := length (campo);
        campo := ' @' + campo;
        curx := curx + 2;

        repeat
            curx := curx - 1;
            c := campo [curx];
        until c <> ' ';

        if c in ['0'..'9'] then
            repeat
                curx := curx - 1;
                c := campo [curx];
            until not (c in ['0'..'9'])
        else
            repeat
                curx := curx - 1;
                c := campo [curx];
            until not (c in ['a'..'z', 'A'..'Z', #128..#255]);

        campo := copy (campo, 3, tam);
        curx := curx - 1;

        if curx <= 0 then
            begin
                curx := 1;
                sintBip;
            end
        else
            sintClek;
    end;

{--------------------------------------------------------}

var campoPc: string;
    buf: array [1..257] of char;
    xx: integer;
    temLetras: boolean;
    sn: string[6];
    v: integer;
    salvaCampo: string;
    primBranco: integer;
    x1, x2: integer;
    comando: string;

const
    espurios: set of char = ['<', '>', '"', '(', ')', '{', '}', '[', ']', '-', '=', '.', '_', '*'];

label moveu, processaC2;
begin
    if sintFalaAcumulada <> '' then
        sintetiza ('');

    if tamVisual > tamanho then
        tamVisual := tamanho;
    with currentWindow do
        if (y = bottom-top+1) and (x+tamVisual > right-left+1) then
            tamVisual := tamVisual - 1;

    campo := copy (campo, 1, tamanho);
    while length (campo) < tamanho do
        campo := campo + ' ';

    primeiraVez := true;
    curx := 1;
    colInic := 1;
    salvaCampo := campo;

    repeat
        if curx < colInic then colInic := curx;
        if curx > colinic+tamVisual then colInic := curx-tamVisual;

        gotoxy (x, y);
        campoPC := copy (campo, colinic, tamVisual);
        write (campoPC);
        gotoxy (curx-colinic+x, y);

        c := readkey;
        sintPara;

        if c = #0 then
            begin
                c2 := readkey;
                sintPara;
processaC2:
                case c2 of
                    ESQ: if curx <= 1 then
                              sintBip
                          else
                              begin
                                  curx := curx - 1;
                                  sintCarac (campo [curx]);
                              end;

                    DIR: begin
                              if curx >= length (campo) then
                                  sintBip
                              else
                                  begin
                                      sintCarac (campo [curx]);
                                      curx := curx + 1;
                                  end;
                         end;

                    HOME: curx := 1;

                    TEND:  begin
                              curx := length (campo)+1;
                              repeat
                                  curx := curx - 1;
                              until (curx = 0) or (campo[curx] <> ' ');
                              curx := curx + 1;
                          end;

                    DEL: delCarac (true);

                    F1:  begin
                             if (getKeyState (VK_MENU) shr 15) <> 0 then
                                 begin
                                     c2 := ALTF1;
                                     goto fechaCampo;
                                 end;
                             falaPalavra;
                         end;

                    CTLF3:
                         begin
                             x1 := curx;
                             while (x1 > 1) and (campo[x1-1] <> ' ') do
                                 x1 := x1 - 1;
                             x2 := curx;
                             while (x2 < length(campo)) and (campo[x2] <> ' ') do
                                  x2 := x2 + 1;
                             if campo[x2] = ' ' then x2 := x2 - 1;
                             comando := copy (campo, x1, x2-x1+1);

                            while (comando <> '') and (comando[1] in espurios) do
                                delete (comando, 1, 1);
                            while (comando <> '') and (comando[length(comando)] in espurios) do
                                delete (comando, length(comando), 1);

                             if comando = '' then
                                 sintBip
                             else
                                 executaArquivo (comando);
                         end;

                    F4:  begin
                             falando := not falando;
                             if falando then
                                 sintSom ('_FALACI')   {Fala acionada}
                             else
                                 sintSom ('_FALDLG');  {Fala desligada}
                         end;

                    CTLF4:  begin
                                sintSom ('_VELOC');    {Qual a velocidade de 1 a 4 ? }
                                repeat
                                    c := sintReadkey;
                                until not keypressed;
                                if (c <> ESC) and (c <> ENTER) then
                                    begin
                                        sintFim;
                                        v := ord (c) - ord('0');
                                        sintInic (v, nomeDirSom);
                                    end;
                            end;
                    F8:     falaHora;
                    CTLF8:  falaDia;

                    CTLF9:  if getKeyState (vk_Menu) < 0 then
                                leitorDeTela
                            else
                                goto fechaCampo;

                    CTLDIR: avancaPalavra;

                    CTLESQ: recuaPalavra;

                    CTLF1:  sintetiza (campo);

                    CTLINS:   begin
                                  xx := length (campo);
                                  repeat
                                      xx := xx - 1;
                                  until (xx = 0) or (campo[xx] <> ' ');
                                  for i := 1 to xx do
                                      buf[i] := campo[i];
                                  buf [xx+1] := #$0;
                                  putClipboard (@buf);
                              end;

                    SHIFTINS:  begin
                                   getClipboard (@buf, length(campo)+1);
                                   fillchar (campo[1], length (campo), ' ');
                                   buf [length(campo)+1] := #$0;
                                   for i := 1 to strLen (@buf)+1 do
                                       begin
                                           if (buf[i] = #$0d) or (buf[i] = #$0a) or
                                              (buf[i] = #$0) then
                                                           goto moveu;
                                           campo[i] := buf [i];
                                       end;
                                   i := strLen (@buf) + 2;
                 moveu:
                                   curx := i;
                               end;

                else
                    goto FechaCampo;
                end
            end
        else
            begin
                c2 := c;
                case c of
                    NOFOCUS: ;
                    GOTFOCUS:  begin
                                   while sintFalando do;
                                   sintetiza (campo);
                                   end;

                    ENTER, CTLENTER, ESC: begin
                                    c2 := c;
                                    goto FechaCampo;
                                end;

                    CTLBS:  begin
                                if (curx > 1) and (campo [curx-1] <> ' ') then
                                    recuaPalavra;
                                x1 := curx;
                                avancaPalavra;
                                x2 := curx;
                                recuaPalavra;
                                for i := x1 to x2-1 do
                                    delCarac (i=x1);
                            end;

                    TAB:   goto fechaCampo;

                    BS:    begin
                               if curx = 1 then
                                   sintBip
                               else
                                   begin
                                       curx := curx - 1;
                                       delCarac (true);
                                   end;
                           end;

                    ^K:    begin
                               str (curx, sn);
                               sintetiza (sn);
                           end;

                    ^D:    if altera then
                           begin
                               for i := curx to length (campo) do
                                   campo [i] := ' ';
                               sintSom ('_APFCPO');
                           end;

                    ^S:    if altera then
                           begin
                               primBranco := length(campo)+1;
                               for i := length(campo) downto 1 do
                                   if campo[i] <> ' ' then
                                       begin
                                           primBranco := i+1;
                                           break;
                                       end;
                               for i := 1 to primBranco-1 do
                                   campo [i] := campo[curx+i-1];
                               for i := length(campo)-curx+1 to length(campo) do
                                   campo [i] := ' ';
                               curx := 1;
                               sintSom ('_APICPO');
                           end;

                    ^U:    if altera then
                                begin
                                    campo := salvaCampo;
                                    curx := 1;
                                    sintBip;
                                    sintBip;
                                    sintBip;
                                end;

                    ^Y:    if altera then
                           begin
                               for i := 1 to length (campo) do
                                   campo [i] := ' ';
                               sintSom ('_CPOAPA');
                               curx := 1;
                           end;

                    ^C:    begin
sintClek;
                               c2 := CTLINS;
                               goto processaC2;
                           end;

                    ^V:    begin
sintClek;
                               c2 := SHIFTINS;
                               goto processaC2;
                           end;

                    ^\:    for i := 1 to length (campo) do
                               sintTelefona (campo [i]);

                else
                    if primeiraVez and sintApagaAuto then
                        begin
                             temLetras := false;
                             for i := curx to length (campo) do
                                 if campo [i] <> ' ' then
                                     temLetras := true;
                             if temLetras then
                                 begin
//                                     sintClek;
//                                     sintClek;
                                     if (c >= #$20) and altera then
                                         for i := 1 to length (campo) do
                                             campo [i] := ' ';
                                 end;
                        end;

                    if c >= #$20 then
                        caracComum (c);
                end;
            end;

        primeiraVez := false;
    until false;

fechaCampo:
    sintEditaCampo := c2;
    sintCursorX := curx;

    gotoxy (x, y);
    campoPC := copy (campo, 1, tamVisual);
    write (campoPC);
    gotoxy (x, y);

    curx := tamanho+1;
    repeat
        curx := curx - 1;
    until (curx = 0) or (campo[curx] <> ' ');

    if curx = 0 then
        campo := ''
    else
        campo := copy (campo, 1, curx);
end;

{--------------------------------------------------------}
{                    edita um item
{--------------------------------------------------------}

function sintEdita (var campo: string; x, y, tamanho: integer;
                     altera: boolean): char;
var
    tamVisual: integer;
begin
    with currentWindow do
        tamVisual := right-(left+x);
    sintEdita := sintEditaCampo (campo, x, y, tamanho, tamVisual, altera);
end;

{--------------------------------------------------------}
{                le uma cadeia ecoando
{--------------------------------------------------------}

procedure sintReadLn (var s: string);
var i: integer;
begin
    s := '';
    if sintEdita (s, wherex, wherey, 81 - wherex, true) = ESC then
        begin
            gotoxy (wherex, wherey);
            for i := 1 to length (s) do write (' ');
            gotoxy (wherex, wherey);
            s := '';
        end;
    writeln;
end;

{--------------------------------------------------------}
{                le um numero ecoando
{--------------------------------------------------------}

procedure sintReadint (var n: integer);
var 
    erro: integer;
    s: string;
begin
    s := '';
    sintEdita (s, wherex, wherey, 81 - wherex, true);
    s := compactaLinha (s);
    if s <> '' then
        val (compactaLinha(s), n, erro);
    writeln;
end;

{--------------------------------------------------------}
{                    tecla corta fala
{--------------------------------------------------------}

procedure sintTeclaCorta (teclaCorta: boolean);
begin
    keyStopsWave := teclaCorta;
end;

var i: integer;
begin
    falando := true;
    sintFalaPont := true;
    falandoSapi := true;
    sintApagaAuto := true;
    sintAcumulaFala := false;
    sintFalaAcumulada := '';

    for i := 0 to TAMCLEK div 4 do
        clek[i] := $80 + random(60);
    for i := TAMCLEK div 4 to TAMCLEK-1 do
        clek[i] := $80;
end.
