{    Programa de Consulta  Biblia             }
{    Autor:  Marcelo Luis Pimentel Pinheiro    }
{    Rio de Janeiro, 18 de fevereiro de 1995    }

Program BibliaVox;

Uses DVCRT, WinDOWS, dvHora, DVWin, dvform, sysUtils,
    Leitura, BibVars, biblifun, bibfunc, bibSom, bibusca, bibler, biBloco;

Procedure Escrevetela;
begin
  textbackground(blue);
  textcolor (LightGray);
  Clrscr;
  MolduraTela;
  gotoxy(26,2);
  write( 'BBLIA SAGRADA  -  ELETRNICA');
  gotoxy(29, 3);
  write ('Verso DOSVOX 3.2 - 2004');
  gotoxy(6, 4);
  Write(' Autores:  Paulo Roberto Barbosa - e-mail: tprobert@intervox.nce.ufrj.br');
  gotoxy(6, 5);
  write('           Marcelo Lus Pimentel - e-mail: marcelo@intervox.nce.ufrj.br');
  gotoxy(6, 6);
  write('           Aperfeioada por Glauco Frius - e-mail: glaucofc@intervox.nce.ufrj.br');
end;

{-----------------------------}

Procedure ajuda1;
begin
  limpabaixo;
  gotoxy(20, 8);
  write ('Ajuda das opes principais do Biblivox:');
  gotoxy(10, 11); write('Opo P: para voc encontrar as passagens, voc');
  gotoxy(10, 12); write('  ter que j saber qual o livro, captulo e versculo');
  gotoxy(10, 13); write('  desejados para ler, sendo o versculo opcional.');
  gotoxy(10, 15); write('Opo L: para voc abrir a Bblia logo no incio.');
  gotoxy(10, 17); write('Opo M: para voc que j colocou marcadores na sua Bblia');
  gotoxy(10, 19); write('Opo I: para conhecer algumas informaes sobre a Bblia.');
  gotoxy(10, 21); write('Opo F1 ou H: mostra um pequeno texto de ajuda.');
  msgbaixo ('bvajuda', 'Os tipos de consultas so: P- Procurar por passagem; T- Procurar por texto; M- Selecionar marcas de livros; L- Leitura desde o incio da Bblia; I- Informaes sobre a Bblia');
{  msgbaixo ('BVTECESC', 'Tecle ESC para voltar ao menu');}
{  repeat until readkey=#27;}
end;

{-----------------------------}

function txtmsg (f: string): string;
begin
    if f = 'BVCFVEL'  then txtmsg := 'Use as setas para selecionar.'
    else
    if f = 'BVVELC'   then txtmsg := 'Velocidade: '
    else
    if f = 'BVFALPON' then txtmsg := 'Falar pontuao: '
    else
    if f = 'BVBIBINI' then txtmsg := 'Bblia de abertura: '
    else
    if f = 'BVCOMSAP' then txtmsg := 'Com SAPI: '
    else
    if f = 'BVNUMSAP' then txtmsg := 'Nmero SAPI: '
    else
    if f = 'BVVEL'    then txtmsg := 'Velocidade SAPI: '
    else
    if f = 'BVTOM'    then txtmsg := 'Tonalidade SAPI: '
    else
    ;
end;

{-----------------------------}

function primeiraLetra (s: string): char;
begin
    s := trim (s);
    delete (s, 2, 999);
    if s = '' then primeiraLetra := ' '
              else primeiraLetra := upcase (s[1]);
end;

{-----------------------------}

procedure formConfig;
var confPontuacao, confBib, confGra,
    confSapi: shortString;
     velGeral, confTipoSapi, confNum, confVeloc, confTonal: integer;
    parm: array [0..255] of char;
    comSapi: boolean;
    i: integer;
    s: string;
begin

    //Recuperando informaes do DOSVOX.INI

    val (sintAmbiente('BIBLIVOX', 'VELOCIDADE'), velGeral, erro);
    if erro <> 0 then velGeral := 0;
    confPontuacao  := (sintAmbiente('BIBLIVOX', 'FALARPONTUACAO'));
    confBib := (sintAmbiente('BIBLIVOX', 'BIBABERT'));
    confGra  := (sintAmbiente('BIBLIVOX', 'GRAVAPROCURA'));

    confSapi       := (sintAmbiente('BIBLIVOX', 'SAPIATIVADO'));

    val (sintAmbiente('BIBLIVOX', 'TIPOSAPI'), confTipoSapi, erro);
    if erro <> 0 then val (sintAmbiente('SERVFALA', 'TIPOSAPI'), confTipoSapi, erro);
    if erro <> 0 then confTipoSapi := 4;

    val (sintAmbiente('BIBLIVOX', 'NUMEROSAPI'), confNum, erro);
    if erro <> 0 then confNum:= 1;

    val (sintAmbiente('BIBLIVOX', 'VELOCIDADESAPI'), confVeloc, erro);
    if erro <> 0 then confVeloc:= 0;
    val (sintAmbiente('BIBLIVOX', 'TONALIDADESAPI'), confTonal, erro);
    if erro <> 0 then confTonal:= 0;

    // Apresentando o formulrio

    textBackground (BLUE);
    writeln;
    msgbaixo ('BVPAICON', 'Painel de configurao');
    sintBip; sintBip;
    textBackground (BLACK);
    for i := 10 to 25 do
        begin
             gotoxy (1, i);  clreol;
        end;
    gotoxy (1, 10);

    formCria;
    formCampoInt ('BVVELC',   txtmsg('BVVELC')   {'Velocidade: '},         velGeral); {''}
    formCampo    ('BVFALPON', txtmsg('BVFALPON') {'Falar pontuao: '},    confPontuacao, 4); {''}
    formCampo    ('BVBIBINI', txtmsg('BVBIBINI') {'Bblia de abertura: '}, confBib, 4); {''}
    formCampo    ('BVGRAPRO', txtmsg('BVGRAPRO') {'Grava procura? '},    confGra, 4); {''}
    formCampo    ('BVCOMSAP', txtmsg('BVCOMSAP') {'Com SAPI: '},           confSapi, 4); {''}
    formCampoInt ('BVTIPSAP', txtmsg('BVTIPSAP') {'Tipo SAPI (4 ou 5): '}, confTipoSapi); {''}
    formCampoInt ('BVNUMSAP', txtmsg('BVNUMSAP') {'Nmero SAPI: '},        confNum); {''}
    formCampoInt ('BVVEL',    txtmsg('BVVEL')    {'Velocidade SAPI: '},    confVeloc); {''}
    formCampoInt ('BVTOM',    txtmsg('BVTOM')    {'Tonalidade SAPI: '},    confTonal); {''}
    formEdita (true);

    //Efetuando modificaes

    if (velGeral < 0) or (velGeral > 5) then
        velGeral:= 0;

    // gravando DOSVOX.INI

    writePrivateProfileString ('BIBLIVOX', 'VELOCIDADE', pchar(intToStr(velGeral)), 'DOSVOX.INI');
    strpCopy (parm, maiuscAnsi(confPontuacao));
    writePrivateProfileString ('BIBLIVOX', 'FALARPONTUACAO', (parm), 'DOSVOX.INI');
    strpCopy (parm, maiuscAnsi(confBib));
    writePrivateProfileString ('BIBLIVOX', 'BIBABERT', (parm), 'DOSVOX.INI');
    strpCopy (parm, maiuscAnsi(confGra));
    writePrivateProfileString ('BIBLIVOX', 'GRAVAPROCURA', (parm), 'DOSVOX.INI');
    strpCopy (parm, maiuscAnsi(confSapi));
    writePrivateProfileString ('BIBLIVOX', 'SAPIATIVADO', (parm), 'DOSVOX.INI');
    writePrivateProfileString ('BIBLIVOX', 'TIPOSAPI', pchar(intToStr(confTipoSapi)), 'DOSVOX.INI');
    writePrivateProfileString ('BIBLIVOX', 'NUMEROSAPI', pchar(intToStr(confNum)), 'DOSVOX.INI');
    writePrivateProfileString ('BIBLIVOX', 'VELOCIDADESAPI', pchar(intToStr(confVeloc)), 'DOSVOX.INI');
    writePrivateProfileString ('BIBLIVOX', 'TONALIDADESAPI', pchar(intToStr(confTonal)), 'DOSVOX.INI');

    msgbaixo ('BVAGUARC', 'Aguarde, configurando');
    sintPara;

    s := sintAmbiente ('BIBLIVOX', 'FALARPONTUACAO');
    if s = '' then
    begin
    sintFalaPont := copy (sintAmbiente ('BIBLIVOX', 'FALARPONTUACAO'), 1, 1) = 'N';
    end
    else
    sintFalaPont := copy (sintAmbiente ('BIBLIVOX', 'FALARPONTUACAO'), 1, 1) <> 'N';
        if sintFalaPont then
begin
  sintFalaPont :=true;
end;

    s := sintAmbiente ('BIBLIVOX', 'GRAVAPROCURA');
    if s = '' then
    begin
    gravaAsProcuras := copy (sintAmbiente ('BIBLIVOX', 'GRAVAPROCURA'), 1, 1) = 'N';
    end
    else
    gravaAsProcuras := copy (sintAmbiente ('BIBLIVOX', 'GRAVAPROCURA'), 1, 1) <> 'N';
        if gravaAsProcuras then
begin
  gravaAsProcuras :=true;
end;

    if confSapi = '' then
        comSapi := primeiraLetra (sintAmbiente ('BIBLIVOX', 'SAPIATIVADO')) = 'S'
    else
        comSapi := primeiraLetra (confSapi) = 'S';

    s := sintAmbiente ('BIBLIVOX', 'VELOCIDADE');
    if (s = '') or (s = '0') then
        s := sintAmbiente ('TRADUTOR', 'VELOCIDADE');
    if s = '' then
        velGeral := 0
    else
        val (s, velGeral, erro);
    sintReinic (velGeral, comSapi, confTipoSapi, confNum, confVeloc, confTonal);

    writeln;
        msgbaixo ('BVOK', 'Ok');
    sintBip; sintBip; sintBip;
    escreveTela;
end;

{-----------------------------}

Procedure ConfiguraBiblia(arqini: String);
var
    config: Text;
    i, j, erroval:Integer;
    strAux: String;
    sz: array [0..144] of char;
begin
  codlivro :=1; capituloatual :=1;

    dirDados := sintAmbiente ('BIBLIVOX', 'DADOSBIB');
    if dirDados = '' then
        begin
            dirDados := 'c:\biblivox';
            strPCopy (sz, dirDados);
            writePrivateProfileString('BIBLIVOX', 'DADOSBIB',     sz, 'DOSVOX.INI');
        end;

assign(config, dirDados + '\' + arqini + '\' + arqini + '.ini');
    {$i-} reset(config); {$i+}
If IOResult <> 0  Then
        begin
        msgbaixo ('BVNAOCFG', 'No encontrei o arquivo de configurao.');
        halt(1);
        end;

    { comea a ler as configuraes das bblias... }

For i:=0 to 67 Do
    begin
    readln(config, straux);
    j := Pos('=', straux);
    If j > 0 Then
        begin
        nomeLivros^[i] := copy(straux, 1, j - 1);
strAux := CompactaLinha(copy(straux, j + 1, length(straux) - j));
        val(strAux, indice[i], erroval);
        end;
    end;

{ ao final dos livros e indices, vem o tamanho... }
    readln(config, straux);
    j:= Pos('=', straux);
    strAux := copy(straux, j+1, length(straux) - j);
    straux := compactalinha(straux);
    Val(straux, TamanhoBiblia, erroval);

{ l do arquivo o Tamanho do Livro de Apocalipse }
    readln(config, straux);
    j:= Pos('=', straux);
    strAux := copy(straux, j+1, length(straux) - j);
    straux := compactalinha(straux);
    Val(straux, TamanhoApocalipse, erroval);

{ l do arquivo o Inicio do ltimo Captulo da Bblia}
    readln(config, straux);
    j:= Pos('=', straux);
    strAux := copy(straux, j+1, length(straux) - j);
    straux := compactalinha(straux);
    Val(straux, InicioUltimoCapitulo, erroval);

{ l do arquivo o Tamanho do arquivo Info }
    readln(config, straux);
    j:= Pos('=', straux);
    strAux := copy(straux, j+1, length(straux) - j);
    straux := compactalinha(straux);
    Val(straux, TamanhoInfo, erroval);

For i:=1 to 66 Do
    begin
    readln(config, straux);
    j := Pos('=', straux);
    If j > 0 Then
        begin
strAux := CompactaLinha(copy(straux, j + 1, length(straux) - j));
        val(strAux, NumeroCap[i], erroval);
        end;
    end;

  dadosDisco := dirDados + '\' + arqini + '\' + arqini + '.dat';
  dadosLinhas := dirDados + '\' + arqini + '\lin_' + arqini + '.dat';
  DadosInfo := dirDados + '\' + arqini + '\inf_' + arqini + '.dat';

   close(Config);
{$i-} close(quelinha); {$i+}
  assign(quelinha, dadoslinhas);
  {$i-} reset(quelinha);{$i+}
  If IOresult <> 0  Then
      write(#7, #7);
end;

{-----------------------------}

Procedure FalaVersao;
var s1: string;

begin
    s1 := sintAmbiente ('BIBLIVOX', 'BIBATU');
    if s1 = 'A' then
    begin
        sintWriteLn (' 7.0 '); msgbaixo ('BVVER_A', 'A - Verso em Portugus: Almeida Atualizada (AA)');
    end;

    if s1 = 'B' then
    begin
        sintWriteLn (' 7.0 '); msgbaixo ('BVVER_B', 'B - Verso em Portugus: Bblia na Linguagem de Hoje (BLH)');
    end;

    if s1 = 'C' then
    begin
        sintWriteLn (' 7.0 '); msgbaixo ('BVVER_C', 'C - Verso em Portugus: Almeida Revisada e Corrigida (ARC)');
    end;

    if s1 = 'D' then
    begin
        sintWriteLn (' 7.0 '); msgbaixo ('BVVER_D', 'D - Verso em Portugus: Almeida Corrigida Fiel (ACF)');
    end;

    if s1 = 'E' then
    begin
        sintWriteLn (' 7.0 '); msgbaixo ('BVVER_E', 'E - Verso em Espanhol: Reina Valera 60 (RV60)');
    end;

    if s1 = 'F' then
    begin
        sintWriteLn (' 7.0 '); msgbaixo ('BVVER_F', 'F - Verso em Francs: Louis Segond (LSG)');
    end;

    if s1 = 'G' then
    begin
        sintWriteLn (' 7.0 '); msgbaixo ('BVVER_G', 'G - Verso em Grego: AT- Moderna Verso e NT- Verso WH');
    end;

    if s1 = 'H' then
    begin
        sintWriteLn (' 7.0 '); msgbaixo ('BVVER_H', 'H - Antigo Testamento em Hebraico (NT- ARA)');
    end;

    if s1 = 'I' then
    begin
        sintWriteLn (' 7.0 '); msgbaixo ('BVVER_I', 'I - Verso em Italiano: Congrezo Episcopale Italiano (CEI)');
    end;

    if s1 = 'J' then
    begin
        sintWriteLn (' 7.0 '); msgbaixo ('BVVER_J', 'J - Verso em Espanhol: Reina Valera 2000 (RV20)');
    end;

    if s1 = 'K' then
    begin
        sintWriteLn (' 7.0 '); msgbaixo ('BVVER_K', 'K - Verso em Ingls: King James Version (KJV)');
    end;

    if s1 = 'L' then
    begin
        sintWriteLn (' 7.0 '); msgbaixo ('BVVER_L', 'L - Verso em Alemo: Martin Luther Bibel 1545 (LUTHER)');
    end;

    if s1 = 'M' then
    begin
        sintWriteLn (' 7.0 '); msgbaixo ('BVVER_M', 'M - Verso comentada por versculos - Almeida Revista e Corrigida Fiel');
    end;

    if s1 = 'N' then
    begin
        sintWriteLn (' 7.0 '); msgbaixo ('BVVER_N', 'N - Verso em Ingls com Strong numbers: King James Version (KJV)');
    end;

    if s1 = 'O' then
    begin
        sintWriteLn (' 7.0 '); msgbaixo ('BVVER_O', 'O - Verso em Portugus: Nova Verso Internacional (NVI)');
    end;

    if s1 = 'R' then
    begin
        sintWriteLn (' 7.0 '); msgbaixo ('BVVER_R', 'R - Verso em Portugus: Almeida Revista e Atualizada (ARA)');
    end;

    if s1 = 'S' then
    begin
        sintWriteLn (' 7.0 '); msgbaixo ('BVVER_S', 'S - Septuaginta e NT grego para estudo com Dicionrio Info');
    end;

    if s1 = 'T' then
    begin
        sintWriteLn (' 7.0 '); msgbaixo ('BVVER_T', 'T- Traduo do Novo Mundo das Escrituras Sagradas');
    end;

    if s1 = 'V' then
    begin
        sintWriteLn (' 7.0 '); msgbaixo ('BVVER_V', 'V- Verso em Latin: Vulgata Latina');
    end;

    if s1 = 'W' then
    begin
        sintWriteLn (' 7.0 '); msgbaixo ('BVVER_W', 'W- Verso em Holands: King James Version');
    end;

    if s1 = 'X' then
    begin
        sintWriteLn (' 7.0 '); msgbaixo ('BVVER_X', 'X- Verso em Esperanto');
    end;

    end;

{-----------------------------}

Procedure TrocaBiblia;
var
    arqini, s1: String;
    retorno:byte;
    sz: array [0..144] of char;

begin
  LimpaBaixo;

  gotoxy(2, 24);
write(barramenu);

(*   gotoxy(20, 11);
  write ('A - Verso em Portugus: Almeida Revista e Atualizada (ARA)');
  gotoxy(20, 12);
  write ('B - Verso em Portugus: Bblia na Linguagem de Hoje (BLH)');
  gotoxy(20, 13);
  write ('C - Verso em Portugus: Almeida Revisada e Corrigida (ARC)');
  gotoxy(20, 14);
  write ('D - Verso em Portugus: Almeida Corrigida Fiel (ACF)');
  gotoxy(20, 15);
  write ('E - Verso em Espanhol: Reina Valera 60 (RV60)');
  gotoxy(20, 16);
  write ('F - Verso em Francs: Louis Segond (LSG)');
  gotoxy(20, 17);
  write ('G - Verso em Grego: AT- Moderna Verso e NT- Verso WH');
  gotoxy(20, 18);
  write ('H - Antigo Testamento em Hebraico (NT- ARA)');
  gotoxy(20, 19);
  write ('I - Verso em Italiano: Congrezo Episcopale Italiano (CEI)');
  gotoxy(20, 20);
  write ('J - Verso em Espanhol: Reina Valera 2000 (RV20)');
  gotoxy(20, 21);
  write ('K - Verso em Ingls: King James Version (KJV)');
  gotoxy(20, 22);
  write ('L - Verso em Alemo: Martin Luther Bibel (LUTHER)');
  gotoxy(20, 23);
  write ('M - Verso comentada por versculos - Almeida Revista e Corrigida Fiel');
  gotoxy(20, 24);
  write ('N - Verso em Ingls com Strong numbers: King James Version (KJV)');
  gotoxy(20, 25);
  write ('O - Verso em Portugus: Nova Verso Internacional (NVI)');
  gotoxy(20, 26);
  write ('R - Verso em Portugus: Almeida Revista e Corrigida (ARC1)');
  gotoxy(20, 27);
  write ('S - Septuaginta e NT grego para estudo com Dicionrio Info');
  gotoxy(20, 28);
  write ('T- Traduo do Novo Mundo das Escrituras Sagradas');
  gotoxy(20, 29);
  write ('V- Verso em Latin: Vulgata Latina');
  gotoxy(20, 30);
  write ('W- Verso em Holands: King James Version');
  gotoxy(20, 31);
  write ('X- Verso em Esperanto');
  gotoxy(2, 8); write(consultar);
*)

  msgbaixo ('BVQUAVER', 'Escolha a verso e tecle ENTER');

            gotoxy (20, 12);
            popupMenuCria (20, 12, 50, 21, RED);

  popupMenuAdiciona ('BVVER_A', 'A - Verso em Portugus: Almeida Atualizada (AA)');
  popupMenuAdiciona ('BVVER_B', 'B - Verso em Portugus: Bblia na Linguagem de Hoje (BLH)');
  popupMenuAdiciona ('BVVER_C', 'C - Verso em Portugus: Almeida Revisada e Corrigida (ARC)');
  popupMenuAdiciona ('BVVER_D', 'D - Verso em Portugus: Almeida Corrigida Fiel (ACF)');
  popupMenuAdiciona ('BVVER_E', 'E - Verso em Espanhol: Reina Valera 60 (RV60)');
  popupMenuAdiciona ('BVVER_F', 'F - Verso em Francs: Louis Segond (LSG)');
  popupMenuAdiciona ('BVVER_G', 'G - Verso em Grego: AT- Moderna Verso e NT- Verso WH');
  popupMenuAdiciona ('BVVER_H', 'H - Antigo Testamento em Hebraico (NT- ARA)');
  popupMenuAdiciona ('BVVER_I', 'I - Verso em Italiano: Congrezo Episcopale Italiano (CEI)');
  popupMenuAdiciona ('BVVER_J', 'J - Verso em Espanhol: Reina Valera 2000 (RV20)');
  popupMenuAdiciona ('BVVER_K', 'K - Verso em Ingls: King James Version (KJV)');
  popupMenuAdiciona ('BVVER_L', 'L - Verso em Alemo: Martin Luther Bibel 1545 (LUTHER)');
  popupMenuAdiciona ('BVVER_M', 'M - Verso comentada por versculos - Almeida Revista e Corrigida Fiel');
  popupMenuAdiciona ('BVVER_N', 'N - Verso em Ingls com Strong numbers: King James Version (KJV)');
  popupMenuAdiciona ('BVVER_O', 'O - Verso em Portugus: Nova Verso Internacional (NVI)');
  popupMenuAdiciona ('BVVER_R', 'R - Verso em Portugus: Almeida Revista e Atualizada (ARA)');
  popupMenuAdiciona ('BVVER_S', 'S - Septuaginta e NT grego para estudo com Dicionrio Info');
  popupMenuAdiciona ('BVVER_T', 'T- Traduo do Novo Mundo das Escrituras Sagradas');
  popupMenuAdiciona ('BVVER_V', 'V- Verso em Latin: Vulgata Latina');
  popupMenuAdiciona ('BVVER_W', 'W- Verso em Holands: King James Version');
  popupMenuAdiciona ('BVVER_X', 'X- Verso em Esperanto');

retorno := popupMenuSeleciona;

case retorno of
1:  arqini := 'ARA';
2: arqini := 'BLH';
3: arqini := 'ARC';
4: arqini := 'ACF';
5: arqini := 'RV60';
6: arqini := 'LSG';
7: arqini := 'GRE';
8: arqini := 'HEB';
9: arqini := 'CEI';
10: arqini := 'RV20';
11: arqini := 'KJV';
12: arqini := 'LUT';
13: arqini := 'ARCF';
14: arqini := 'KSN';
15: arqini := 'NVI';
16: arqini := 'ARC1';
17: arqini := 'SEP';
18: arqini := 'TNM';
19: arqini := 'VUL';
20: arqini := 'HOL';
21: arqini := 'ESP';
Else
msgbaixo ('BVDESIST', 'Operao cancelada.');
exit;
END;

    if (arqini = 'ARA') or (arqini = '') then
    begin
    s1 := 'A';
            strPCopy (sz, s1);
            writePrivateProfileString('BIBLIVOX', 'BIBATU',     sz, 'DOSVOX.INI');
    end;

    if arqini = 'BLH' then
    begin
    s1 := 'B';
            strPCopy (sz, s1);
            writePrivateProfileString('BIBLIVOX', 'BIBATU',     sz, 'DOSVOX.INI');
    end;

    if arqini = 'ARC' then
    begin
    s1 := 'C';
            strPCopy (sz, s1);
            writePrivateProfileString('BIBLIVOX', 'BIBATU',     sz, 'DOSVOX.INI');
    end;

    if arqini = 'ACF' then
    begin
    s1 := 'D';
            strPCopy (sz, s1);
            writePrivateProfileString('BIBLIVOX', 'BIBATU',     sz, 'DOSVOX.INI');
    end;

    if arqini = 'RV60' then
    begin
    s1 := 'E';
            strPCopy (sz, s1);
            writePrivateProfileString('BIBLIVOX', 'BIBATU',     sz, 'DOSVOX.INI');
    end;

    if arqini = 'LSG' then
    begin
    s1 := 'F';
            strPCopy (sz, s1);
            writePrivateProfileString('BIBLIVOX', 'BIBATU',     sz, 'DOSVOX.INI');
    end;

    if arqini = 'GRE' then
    begin
    s1 := 'G';
            strPCopy (sz, s1);
            writePrivateProfileString('BIBLIVOX', 'BIBATU',     sz, 'DOSVOX.INI');
    end;

    if arqini = 'HEB' then
    begin
    s1 := 'H';
            strPCopy (sz, s1);
            writePrivateProfileString('BIBLIVOX', 'BIBATU',     sz, 'DOSVOX.INI');
    end;

    if arqini = 'CEI' then
    begin
    s1 := 'I';
            strPCopy (sz, s1);
            writePrivateProfileString('BIBLIVOX', 'BIBATU',     sz, 'DOSVOX.INI');
    end;

    if arqini = 'RV20' then
    begin
    s1 := 'J';
            strPCopy (sz, s1);
            writePrivateProfileString('BIBLIVOX', 'BIBATU',     sz, 'DOSVOX.INI');
    end;

    if arqini = 'KJV' then
    begin
    s1 := 'K';
            strPCopy (sz, s1);
            writePrivateProfileString('BIBLIVOX', 'BIBATU',     sz, 'DOSVOX.INI');
    end;

    if arqini = 'LUT' then
    begin
    s1 := 'L';
            strPCopy (sz, s1);
            writePrivateProfileString('BIBLIVOX', 'BIBATU',     sz, 'DOSVOX.INI');
    end;

    if arqini = 'ARCF' then
    begin
    s1 := 'M';
            strPCopy (sz, s1);
            writePrivateProfileString('BIBLIVOX', 'BIBATU',     sz, 'DOSVOX.INI');
    end;

    if arqini = 'KSN' then
    begin
    s1 := 'N';
            strPCopy (sz, s1);
            writePrivateProfileString('BIBLIVOX', 'BIBATU',     sz, 'DOSVOX.INI');
    end;

    if arqini = 'NVI' then
    begin
    s1 := 'O';
            strPCopy (sz, s1);
            writePrivateProfileString('BIBLIVOX', 'BIBATU',     sz, 'DOSVOX.INI');
    end;

    if arqini = 'ARC1' then
    begin
    s1 := 'R';
            strPCopy (sz, s1);
            writePrivateProfileString('BIBLIVOX', 'BIBATU',     sz, 'DOSVOX.INI');
    end;

    if arqini = 'SEP' then
    begin
    s1 := 'S';
            strPCopy (sz, s1);
            writePrivateProfileString('BIBLIVOX', 'BIBATU',     sz, 'DOSVOX.INI');
    end;

    if arqini = 'TNM' then
    begin
    s1 := 'T';
            strPCopy (sz, s1);
            writePrivateProfileString('BIBLIVOX', 'BIBATU',     sz, 'DOSVOX.INI');
    end;

    if arqini = 'VUL' then
    begin
    s1 := 'V';
            strPCopy (sz, s1);
            writePrivateProfileString('BIBLIVOX', 'BIBATU',     sz, 'DOSVOX.INI');
    end;

    if arqini = 'HOL' then
    begin
    s1 := 'W';
            strPCopy (sz, s1);
            writePrivateProfileString('BIBLIVOX', 'BIBATU',     sz, 'DOSVOX.INI');
    end;

    if arqini = 'ESP' then
    begin
    s1 := 'X';
            strPCopy (sz, s1);
            writePrivateProfileString('BIBLIVOX', 'BIBATU',     sz, 'DOSVOX.INI');
    end;

    ConfiguraBiblia (arqini);
                msgbaixo ('BVOK', 'OK');

if s1 = 'A' then s1 := 'A - Verso em Portugus: Almeida Revista e Atualizada (ARA';
if s1 = 'B' then s1 := 'B - Verso em Portugus: Bblia na Linguagem de Hoje (BLH';
if s1 = 'C' then s1 := 'C - Verso em Portugus: Almeida Revisada e Corrigida (ARC)';
if s1 = 'D' then s1 := 'D - Verso em Portugus: Almeida Corrigida Fiel (ACF';
if s1 = 'E' then s1 := 'E - Verso em Espanhol: Reina Valera 60 (RV60';
if s1 = 'F' then s1 := 'F - Verso em Francs: Louis Segond (LSG';
if s1 = 'G' then s1 := 'G - Verso em Grego: AT- Moderna Verso e NT- Verso WH';
if s1 = 'H' then s1 := 'H - Antigo Testamento em Hebraico (NT- ARA';
if s1 = 'I' then s1 := 'I - Verso em Italiano: Congrezo Episcopale Italiano (CEI';
if s1 = 'J' then s1 := 'J - Verso em Espanhol: Reina Valera 2000 (RV20';
if s1 = 'K' then s1 := 'K - Verso em Ingls: King James Version (KJV)';
if s1 = 'L' then s1 := 'L - Verso em Alemo: Martin Luther Bibel 1545 (LUTHER)';
if s1 = 'M' then s1 := 'M - Verso comentada por versculos - Almeida Revista e Corrigida Fiel';
if s1 = 'N' then s1 := 'N - Verso em Ingls com Strong numbers: King James Version (KJV)';
if s1 = 'O' then s1 := 'O - Verso em Portugus: Nova Verso Internacional (NVI)';
if s1 = 'R' then s1 := 'R - Verso em Portugus: Almeida Revista e Corrigida (ARC1';
if s1 = 'S' then s1 := 'S - Septuaginta e NT grego para estudo com Dicionrio Info';
if s1 = 'T' then s1 := 'T- Traduo do Novo Mundo das Escrituras Sagradas';
if s1 = 'V' then s1 := 'V- Verso em Latin: Vulgata Latina';
if s1 = 'W' then s1 := 'W- Verso em Holands: King James Version';
if s1 = 'X' then s1 := 'X- Verso em Esperanto';

    clrscr;
    strPCopy (tituloJan, 'BIBLIVOX ' + '7.0 ' + s1);
    setWindowText (crtWindow, tituloJan);
end;

{-----------------------------}

Procedure Inicializa;
var s, s1: string;
     erro, n: integer;
    sz: array [0..144] of char;
    comSapi: boolean;
     velGeral, confTipoSapi, confNum, confVeloc, confTonal: integer;
begin
    s := sintAmbiente ('BIBLIVOX', 'VELOCIDADE');
    if s = '' then
        n := 0
    else
        val (s, n, erro);
   sintInic (n, sintAmbiente ('BIBLIVOX', 'DIRBIBLIVOX'));

  EscreveTela;
  sintteclacorta(true);
  msgbaixo ('BVMSG1', '');
  msgbaixo ('BVMSG2', 'Bblia Eletrnica Vox');
    s := sintAmbiente ('BIBLIVOX', 'FALARPONTUACAO');
    if s = '' then
    begin
    sintFalaPont := copy (sintAmbiente ('BIBLIVOX', 'FALARPONTUACAO'), 1, 1) = 'N';
    end
    else
    sintFalaPont := copy (sintAmbiente ('BIBLIVOX', 'FALARPONTUACAO'), 1, 1) <> 'N';
        if sintFalaPont then
begin
  sintFalaPont :=true;
end;

    s := sintAmbiente ('BIBLIVOX', 'GRAVAPROCURA');
    if s = '' then
    begin
    gravaAsProcuras := copy (sintAmbiente ('BIBLIVOX', 'GRAVAPROCURA'), 1, 1) = 'N';
    end
    else
    gravaAsProcuras := copy (sintAmbiente ('BIBLIVOX', 'GRAVAPROCURA'), 1, 1) <> 'N';
        if gravaAsProcuras then
begin
  gravaAsProcuras :=true;
end;

    dirDados := sintAmbiente ('BIBLIVOX', 'DADOSBIB');
    if dirDados = '' then
        begin
            dirDados := 'c:\biblivox';
            strPCopy (sz, dirDados);
            writePrivateProfileString('BIBLIVOX', 'DADOSBIB',     sz, 'DOSVOX.INI');
        end;

  DadosMarca := dirDados + '\marcas.dat'; {' + arqini + '\marcas.dat';}
    LeMarcadores;

    comSapi := primeiraLetra (sintAmbiente('BIBLIVOX', 'SAPIATIVADO')) = 'S';

    val (sintAmbiente('BIBLIVOX', 'TIPOSAPI'), confTipoSapi, erro);
    if erro <> 0 then val (sintAmbiente('SERVFALA', 'TIPOSAPI'), confTipoSapi, erro);
    if erro <> 0 then confTipoSapi := 4;

    val (sintAmbiente('BIBLIVOX', 'NUMEROSAPI'), confNum, erro);
    if erro <> 0 then val (sintAmbiente('SERVFALA', 'VOZ'), confNum, erro);
    if erro <> 0 then confNum := 1;

    s := sintAmbiente ('BIBLIVOX', 'VELOCIDADE');
    if (s = '') or (s = '0') then
        s := sintAmbiente ('BIBLIVOX', 'VELOCIDADE');
    if s = '' then
        velGeral := 0
    else
        val (s, velGeral, erro);
//    sintReinic (velGeral, comSapi, confTipoSapi, confNum, confVeloc, confTonal);

    val (sintAmbiente('BIBLIVOX', 'VELOCIDADESAPI'), confVeloc, erro);
    if erro <> 0 then confVeloc:= 0;
    val (sintAmbiente('BIBLIVOX', 'TONALIDADESAPI'), confTonal, erro);
    if erro <> 0 then confTonal:= 0;

    s := sintAmbiente ('BIBLIVOX', 'SAPIATIVADO');
    if (s <> '') and (upcase(s[1]) = 'S') then
    sintReinic (velGeral, comSapi, confTipoSapi, confNum, confVeloc, confTonal);

    s := sintAmbiente ('BIBLIVOX', 'GRAVAPROCURA');
    if s = '' then
    begin
            s := 'SIM';
            strPCopy (sz, s);
            writePrivateProfileString('BIBLIVOX', 'GRAVAPROCURA',     sz, 'DOSVOX.INI');
    end;

    s := sintAmbiente ('BIBLIVOX', 'DIRGRAVA');
    if s = '' then
    begin
            s := 'C:\Winvox\treino';
            strPCopy (sz, s);
            writePrivateProfileString('BIBLIVOX', 'DIRGRAVA',     sz, 'DOSVOX.INI');
    end;

    s1 := sintAmbiente ('BIBLIVOX', 'BIBABERT');
    if s1 = '' then
        begin
            s1 := 'A';
            strPCopy (sz, s1);
            writePrivateProfileString('BIBLIVOX', 'BIBABERT',     sz, 'DOSVOX.INI');
            writePrivateProfileString('BIBLIVOX', 'BIBATU',     sz, 'DOSVOX.INI');
        end;

    s1 := sintAmbiente ('BIBLIVOX', 'BIBABERT');

    if s1 = 'A' then
    begin
    msgbaixo ('BVVER_A', 'A - Verso em Portugus: Almeida Atualizada (AA)');
    ConfiguraBiblia('ARA');
            strPCopy (sz, s1);
            writePrivateProfileString('BIBLIVOX', 'BIBATU',     sz, 'DOSVOX.INI');
if s1 = 'A' then s1 := 'A - Verso em Portugus: Almeida Revista e Atualizada (ARA';
    clrscr;
    strPCopy (tituloJan, 'BIBLIVOX ' + '7.0 ' + s1);
    setWindowText (crtWindow, tituloJan);
    exit;
    end
    else

    if s1 = 'B' then
    begin
    msgbaixo ('BVVER_B', 'B - Verso em Portugus: Bblia na Linguagem de Hoje (BLH)');
    ConfiguraBiblia('BLH');
            strPCopy (sz, s1);
            writePrivateProfileString('BIBLIVOX', 'BIBATU',     sz, 'DOSVOX.INI');
if s1 = 'B' then s1 := 'B - Verso em Portugus: Bblia na Linguagem de Hoje (BLH';
    clrscr;
    strPCopy (tituloJan, 'BIBLIVOX ' + '7.0 ' + s1);
    setWindowText (crtWindow, tituloJan);
    exit;
    end
    else

    if s1 = 'C' then
    begin
    msgbaixo ('BVVER_C', 'C - Verso em Portugus: Almeida Revisada e Corrigida (ARC)');
    ConfiguraBiblia('ARC');
            strPCopy (sz, s1);
            writePrivateProfileString('BIBLIVOX', 'BIBATU',     sz, 'DOSVOX.INI');
if s1 = 'C' then s1 := 'C - Verso em Portugus: Almeida Revisada e Corrigida (ARC)';
    clrscr;
    strPCopy (tituloJan, 'BIBLIVOX ' + '7.0 ' + s1);
    setWindowText (crtWindow, tituloJan);
    exit;
    end
    else

    if s1 = 'D' then
    begin
    msgbaixo ('BVVER_D', 'D - Verso em Portugus: Almeida Corrigida Fiel (ACF)');
    ConfiguraBiblia('ACF');
            strPCopy (sz, s1);
            writePrivateProfileString('BIBLIVOX', 'BIBATU',     sz, 'DOSVOX.INI');
if s1 = 'D' then s1 := 'D - Verso em Portugus: Almeida Corrigida Fiel (ACF';
    clrscr;
    strPCopy (tituloJan, 'BIBLIVOX ' + '7.0 ' + s1);
    setWindowText (crtWindow, tituloJan);
    exit;
    end
    else

    if s1 = 'E' then
    begin
    msgbaixo ('BVVER_E', 'E - Verso em Espanhol: Reina Valera 60 (RV60)');
    ConfiguraBiblia('RV60');
            strPCopy (sz, s1);
            writePrivateProfileString('BIBLIVOX', 'BIBATU',     sz, 'DOSVOX.INI');
if s1 = 'E' then s1 := 'E - Verso em Espanhol: Reina Valera 60 (RV60';
    clrscr;
    strPCopy (tituloJan, 'BIBLIVOX ' + '7.0 ' + s1);
    setWindowText (crtWindow, tituloJan);
    exit;
    end
    else

    if s1 = 'F' then
    begin
    msgbaixo ('BVVER_F', 'F - Verso em Francs: Louis Segond (LSG)');
    ConfiguraBiblia('LSG');
            strPCopy (sz, s1);
            writePrivateProfileString('BIBLIVOX', 'BIBATU',     sz, 'DOSVOX.INI');
if s1 = 'F' then s1 := 'F - Verso em Francs: Louis Segond (LSG';
    clrscr;
    strPCopy (tituloJan, 'BIBLIVOX ' + '7.0 ' + s1);
    setWindowText (crtWindow, tituloJan);
    exit;
    end
    else

    if s1 = 'G' then
    begin
    msgbaixo ('BVVER_G', 'G - Verso em Grego: AT- Moderna Verso e NT- Verso WH');
    ConfiguraBiblia('GRE');
            strPCopy (sz, s1);
            writePrivateProfileString('BIBLIVOX', 'BIBATU',     sz, 'DOSVOX.INI');
if s1 = 'G' then s1 := 'G - Verso em Grego: AT- Moderna Verso e NT- Verso WH';
    clrscr;
    strPCopy (tituloJan, 'BIBLIVOX ' + '7.0 ' + s1);
    setWindowText (crtWindow, tituloJan);
    exit;
    end
    else

    if s1 = 'H' then
    begin
    msgbaixo ('BVVER_H', 'H - Antigo Testamento em Hebraico (NT- ARA)');
    ConfiguraBiblia('HEB');
            strPCopy (sz, s1);
            writePrivateProfileString('BIBLIVOX', 'BIBATU',     sz, 'DOSVOX.INI');
if s1 = 'H' then s1 := 'H - Antigo Testamento em Hebraico (NT- ARA';
    clrscr;
    strPCopy (tituloJan, 'BIBLIVOX ' + '7.0 ' + s1);
    setWindowText (crtWindow, tituloJan);
    exit;
    end
    else

    if s1 = 'I' then
    begin
    msgbaixo ('BVVER_I', 'I - Verso em Italiano: Congrezo Episcopale Italiano (CEI)');
    ConfiguraBiblia('CEI');
            strPCopy (sz, s1);
            writePrivateProfileString('BIBLIVOX', 'BIBATU',     sz, 'DOSVOX.INI');
if s1 = 'I' then s1 := 'I - Verso em Italiano: Congrezo Episcopale Italiano (CEI';
    clrscr;
    strPCopy (tituloJan, 'BIBLIVOX ' + '7.0 ' + s1);
    setWindowText (crtWindow, tituloJan);
    exit;
    end
    else

    if s1 = 'J' then
    begin
    msgbaixo ('BVVER_J', 'J - Verso em Espanhol: Reina Valera 2000 (RV20)');
    ConfiguraBiblia('RV20');
            strPCopy (sz, s1);
            writePrivateProfileString('BIBLIVOX', 'BIBATU',     sz, 'DOSVOX.INI');
if s1 = 'J' then s1 := 'J - Verso em Espanhol: Reina Valera 2000 (RV20';
    clrscr;
    strPCopy (tituloJan, 'BIBLIVOX ' + '7.0 ' + s1);
    setWindowText (crtWindow, tituloJan);
    exit;
    end
    else

    if s1 = 'K' then
    begin
    msgbaixo ('BVVER_K', 'K - Verso em Ingls: King James Version (KJV)');
    ConfiguraBiblia('KJV');
            strPCopy (sz, s1);
            writePrivateProfileString('BIBLIVOX', 'BIBATU',     sz, 'DOSVOX.INI');
if s1 = 'K' then s1 := 'K - Verso em Ingls: King James Version (KJV)';
    clrscr;
    strPCopy (tituloJan, 'BIBLIVOX ' + '7.0 ' + s1);
    setWindowText (crtWindow, tituloJan);
    exit;
    end
    else

    if s1 = 'L' then
    begin
    msgbaixo ('BVVER_L', 'L - Verso em Alemo: Martin Luther Bibel 1545 (LUTHER)');
    ConfiguraBiblia('LUT');
            strPCopy (sz, s1);
            writePrivateProfileString('BIBLIVOX', 'BIBATU',     sz, 'DOSVOX.INI');
if s1 = 'L' then s1 := 'L - Verso em Alemo: Martin Luther Bibel 1545 (LUTHER)';
    clrscr;
    strPCopy (tituloJan, 'BIBLIVOX ' + '7.0 ' + s1);
    setWindowText (crtWindow, tituloJan);
    exit;
    end
    else

    if s1 = 'M' then
    begin
    msgbaixo ('BVVER_M', 'M - Verso comentada por versculos - Almeida Revista e Corrigida Fiel');
    ConfiguraBiblia('ARCF');
            strPCopy (sz, s1);
            writePrivateProfileString('BIBLIVOX', 'BIBATU',     sz, 'DOSVOX.INI');
if s1 = 'M' then s1 := 'M - Verso comentada por versculos - Almeida Revista e Corrigida Fiel';
    clrscr;
    strPCopy (tituloJan, 'BIBLIVOX ' + '7.0 ' + s1);
    setWindowText (crtWindow, tituloJan);
    exit;
    end
    else

    if s1 = 'N' then
    begin
    msgbaixo ('BVVER_N', 'N - Verso em Ingls com Strong numbers: King James Version (KJV)');
    ConfiguraBiblia('KSN');
            strPCopy (sz, s1);
            writePrivateProfileString('BIBLIVOX', 'BIBATU',     sz, 'DOSVOX.INI');
if s1 = 'N' then s1 := 'N - Verso em Ingls com Strong numbers: King James Version (KJV)';
    clrscr;
    strPCopy (tituloJan, 'BIBLIVOX ' + '7.0 ' + s1);
    setWindowText (crtWindow, tituloJan);
    exit;
    end
    else

    if s1 = 'O' then
    begin
    msgbaixo ('BVVER_O', 'O - Verso em Portugus: Nova Verso Internacional (NVI)');
    ConfiguraBiblia('NVI');
            strPCopy (sz, s1);
            writePrivateProfileString('BIBLIVOX', 'BIBATU',     sz, 'DOSVOX.INI');
if s1 = 'O' then s1 := 'O - Verso em Portugus: Nova Verso Internacional (NVI)';
    clrscr;
    strPCopy (tituloJan, 'BIBLIVOX ' + '7.0 ' + s1);
    setWindowText (crtWindow, tituloJan);
    exit;
    end
    else

    if s1 = 'R' then
    begin
    msgbaixo ('BVVER_R', 'R - Verso em Portugus: Almeida Revista e Atualizada (ARA)');
    ConfiguraBiblia('ARC1');
            strPCopy (sz, s1);
            writePrivateProfileString('BIBLIVOX', 'BIBATU',     sz, 'DOSVOX.INI');
if s1 = 'R' then s1 := 'R - Verso em Portugus: Almeida Revista e Corrigida (ARC1';
    clrscr;
    strPCopy (tituloJan, 'BIBLIVOX ' + '7.0 ' + s1);
    setWindowText (crtWindow, tituloJan);
    exit;
    end
    else

    if s1 = 'S' then
    begin
    msgbaixo ('BVVER_S', 'S - Septuaginta e NT grego para estudo com Dicionrio Info');
    ConfiguraBiblia('SEP');
            strPCopy (sz, s1);
            writePrivateProfileString('BIBLIVOX', 'BIBATU',     sz, 'DOSVOX.INI');
if s1 = 'S' then s1 := 'S - Septuaginta e NT grego para estudo com Dicionrio Info';
    clrscr;
    strPCopy (tituloJan, 'BIBLIVOX ' + '7.0 ' + s1);
    setWindowText (crtWindow, tituloJan);
    exit;
    end
    else

    if s1 = 'T' then
    begin
    msgbaixo ('BVVER_T', 'T- Traduo do Novo Mundo das Escrituras Sagradas');
    ConfiguraBiblia('TNM');
            strPCopy (sz, s1);
            writePrivateProfileString('BIBLIVOX', 'BIBATU',     sz, 'DOSVOX.INI');
if s1 = 'T' then s1 := 'T- Traduo do Novo Mundo das Escrituras Sagradas';
    clrscr;
    strPCopy (tituloJan, 'BIBLIVOX ' + '7.0 ' + s1);
    setWindowText (crtWindow, tituloJan);
    exit;
    end
    else

    if s1 = 'V' then
    begin
    msgbaixo ('BVVER_V', 'V- Verso em Latin: Vulgata Latina');
    ConfiguraBiblia('VUL');
            strPCopy (sz, s1);
            writePrivateProfileString('BIBLIVOX', 'BIBATU',     sz, 'DOSVOX.INI');
if s1 = 'V' then s1 := 'V- Verso em Latin: Vulgata Latina';
    clrscr;
    strPCopy (tituloJan, 'BIBLIVOX ' + '7.0 ' + s1);
    setWindowText (crtWindow, tituloJan);
    exit;
    end
    else

    if s1 = 'W' then
    begin
    msgbaixo ('BVVER_W', 'V- Verso em Holands: King James Version');
    ConfiguraBiblia('HOL');
            strPCopy (sz, s1);
            writePrivateProfileString('BIBLIVOX', 'BIBATU',     sz, 'DOSVOX.INI');
if s1 = 'W' then s1 := 'W- Verso em Holands: King James Version';
    clrscr;
    strPCopy (tituloJan, 'BIBLIVOX ' + '7.0 ' + s1);
    setWindowText (crtWindow, tituloJan);
    exit;
    end
    else

    if s1 = 'X' then
    begin
    msgbaixo ('BVVER_X', 'X- Verso em Esperanto');
    ConfiguraBiblia('ESP');
            strPCopy (sz, s1);
            writePrivateProfileString('BIBLIVOX', 'BIBATU',     sz, 'DOSVOX.INI');
if s1 = 'X' then s1 := 'X- Verso em Esperanto';
    clrscr;
    strPCopy (tituloJan, 'BIBLIVOX ' + '7.0 ' + s1);
    setWindowText (crtWindow, tituloJan);
    exit;
    end
    else

    if s1 = '' then
    begin
    msgbaixo ('BVVER_A', 'A - Verso em Portugus: Almeida Atualizada (AA)');
    ConfiguraBiblia('ARA');
            strPCopy (sz, s1);
            writePrivateProfileString('BIBLIVOX', 'BIBATU',     sz, 'DOSVOX.INI');
if s1 = '' then s1 := 'A - Verso em Portugus: Almeida Revista e Atualizada (ARA';
    clrscr;
    strPCopy (tituloJan, 'BIBLIVOX ' + '7.0 ' + s1);
    setWindowText (crtWindow, tituloJan);
    exit;
    end;

end;

Procedure apresenta;
begin
  gotoxy(33, 8);  write('Apresentao:');
  gotoxy(15,11);  write('Programa de consulta as passagens da Bblia');
  gotoxy(12,14);  write(
  'Para adquirir o produto fale com: Glauco Frius Constantino de Oliveira');
  gotoxy(12,15);  write(
  'Atravs do telefone: (0xx21) 2258-6675 - ou baixe em:');
  gotoxy(12,16);  write(
  'http://intervox.nce.ufrj.br/~glaucofc/biblivox.zip');
  gotoxy(12,17);  write(
  'ou corresponda-se com:');
  gotoxy(12,18);  write(
  'Rua Jorge Yunes, 380, ap 104 - CEP: 22795-295');
  gotoxy(12,19);  write(
  'ou atravs do e-mail: <glauco.fc@uol.com.br>');
{  gotoxy(21,24);  write('Tecle ENTER para continuar');}
{  msgbaixo ('BVTECENT', 'Tecle ENTER');}
{  repeat until readkey = #13;}
//sintclek;
 end;

Function Finaliza:Char;
begin
  LimpaBaixo;
  gotoxy(2,24);
  write('                Que as palavras aqui lidas iluminem sua vida !               ');
  gotoxy(33, 8); write('Finalizao:');
  gotoxy(20, 11); write('Obrigado por utilizar nossos programas');
  textbackground(red); textcolor(white); highvideo;
  gotoxy(2,13); write(
'            Este produto no deve ser copiado de nenhuma forma!             ');
  gotoxy(2, 14); write(
'         Qualquer cpia ilegal sofrer as medidas cabveis da Lei.          ');
  normvideo; textbackground(blue); textcolor(lightgray);
  gotoxy(5,16); write(
'Caso voc desejar maiores informaes sobre a Bblia, fale conosco.');
  gotoxy(12,17); write(
'Jesus Cristo  o nico caminho para nossa Salvao.');
  gotoxy(15,18); write(
'Atenda ao seu chamado antes que seja tarde !');
  gotoxy(5,19); write(
'Lembre-se: A palavra de Deus  alimento para nossas almas.');
  gotoxy(18, 21); write(
'Que Jesus te abenoe e te guarde.');

  GravaMarcadores;
  close(quelinha);
  finaliza := #255;
  sintteclacorta (true);
  msgbaixo ('BVMSGFIM', 'Que Deus te abenoe e te guarde!');
  msgbaixo ('BVSOMFIM', 'Fim do Biblivox');
delay (3);
  sintFim;
  doneWinCrt;
end;

Procedure PegaOpcao;
var c: char;
begin
  sintteclacorta(true);
repeat
  LimpaBaixo;
  gotoxy(2, 24); write(barramenu);
  gotoxy(20, 11);
  write('L - Leitura corrente da Biblia');
  gotoxy(20, 13);
  write ('P - Procurar por passagem');
  gotoxy(20,15);
  write ('T - Procurar por texto');
  gotoxy(20, 17);
  write ('M - Localizar marcadores de livro');
  gotoxy(20, 19);
  write ('I - Informaes sobre a Bblia');
 gotoxy(20, 21);
  write('F - Finalizar programa');
  gotoxy(2, 8); write(consultar);
  repeat
  msgbaixo ('BVTPCONS', 'Qual o tipo de consulta? ');
    opc :=upcase( readKey);
//    If opc =#0  then lixo :=readkey;
    If (opc in [ENTER, F5, F10..f12]) then opc :=#0;

    If opc =F1  then     Ajuda1;
    If opc =F2  then     LivroSalm;
    If opc =F3  then     LivroProverbi;
    If opc =F4  then     formConfig;
    If opc =F6  then     NovoTestamen;
    If opc =F8  then     FalaHora;
//    If opc =CTLF8  then     FalaDia; {Tecla em conflito com a letra 'e' que muda velocidade}
    If opc =F9  then     FimBib;

    If opc =INS  then       AntigoTestamen;

    If opc =F7  then      begin
c := '5';
        begin
            sintFim;
            sintInic (ord(c) - ord('0'), sintambiente ('BIBLIVOX', 'DIRBIBLIVOX'));
end;
end;
    If opc =CTLF3  then       begin
c := '4';
        begin
            sintFim;
            sintInic (ord(c) - ord('0'), sintambiente ('BIBLIVOX', 'DIRBIBLIVOX'));
end;
end;
    If opc =CTLF2  then        begin
c := '3';
        begin
            sintFim;
            sintInic (ord(c) - ord('0'), sintambiente ('BIBLIVOX', 'DIRBIBLIVOX'));
end;
end;
    If opc =CTLF1  then        begin
c := '2';
        begin
            sintFim;
            sintInic (ord(c) - ord('0'), sintambiente ('BIBLIVOX', 'DIRBIBLIVOX'));
end;
end;

  Until opc in [' ', '1', '2', '3', '4', '5', '6', '7', '8', '9', '0', 'O', 'P','I','F','M','L', 'V', ^V, 'T', ^T, ESC, ENTER,
'E', 'Q', 'W', 'H', '?', 'S', 'D',
'N', 'U', 'u', ^U, 'X', ^X];
    Case opc of

      '1': begin TrocaBiblia;
        Letudo1; end;

      '2': begin TrocaBiblia;
        Letudo2; end;

      '3': begin TrocaBiblia;
        Letudo3; end;

      '4': begin TrocaBiblia;
        Letudo4; end;

      '5': begin TrocaBiblia;
        Letudo5; end;

      '6': begin TrocaBiblia;
        Letudo6; end;

      '7': begin TrocaBiblia;
        Letudo7; end;

      '8': begin TrocaBiblia;
        Letudo8; end;

      '9': begin TrocaBiblia;
        Letudo9; end;

      '0': begin TrocaBiblia;
        Letudo0; end;

      'L', ' ': Letudo;

      'V': TrocaBiblia;

      ^V: FalaVersao;

      'O': begin
        msgbaixo ('BVANTTES', 'Antigo Testamento!');
Letudo;
end;

      'P': ProcuraCapitulo;
      'T': ProcuraTexto;
      'U': AntigoTestamen;
      'I': Informacoes;
      'M': Begin
        assign(arquivo, dadosdisco);
        {$i-}reset(arquivo);{$i+}
        If IOresult <> 0  Then
            msgbaixo ('BVERRODT','Erro grave nos dados do sistema !')
        Else begin
               pontaux :=0;
               ponteiro :=0;
               py :=1; px :=1;
               vaiparamarca;
               If ponteiro > 0  Then
               begin
                  letrecho;
                  processaLeitura;
               end;
             end;
        end;

'W': LivroSalm;

'X': LivroProverbi;

'N', 'S': NovoTestamen;

'Q': FalaDia;

                    ^X: begin
delay (3);
    SintFim;
    doneWinCrt;
end;

      'F', ESC: opc :=Finaliza;
//      #$1B: opc := #255;
      'A', 'H', '?': Ajuda1;
      Else begin
              msgbaixo ( 'BVOPCINV','Opo errada');
              gotoxy(2,24); write(barramenu);
           end;
    end;
  Until opc = #255;
end;

begin
  Inicializa;
  apresenta;
  {  verificacopia;}
  pegaopcao;
end.
